/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sdk.spring;

import org.apache.shenyu.sdk.spring.proxy.ShenyuClientProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ShenyuClientFactoryBean
implements FactoryBean<Object>,
InitializingBean,
ApplicationContextAware,
BeanFactoryAware {
    private Class<?> type;
    private String name;
    private String url;
    private String contextId;
    private String path;
    private ApplicationContext applicationContext;
    private BeanFactory beanFactory;
    private Class<?> fallback = Void.TYPE;
    private Class<?> fallbackFactory = Void.TYPE;

    public void afterPropertiesSet() {
        Assert.hasText((String)this.contextId, (String)"Context id must be set");
        Assert.hasText((String)this.name, (String)"Name must be set");
    }

    public Object getObject() {
        return this.getTarget();
    }

    private Object getTarget() {
        if (StringUtils.hasText((String)this.url) && !this.url.startsWith("http")) {
            this.url = "http://" + this.url;
        }
        return ShenyuClientProxyFactory.createProxy(this.type, this.applicationContext, this);
    }

    public Class<?> getObjectType() {
        return this.type;
    }

    public boolean isSingleton() {
        return true;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public Class<?> getFallback() {
        return this.fallback;
    }

    public void setFallback(Class<?> fallback) {
        this.fallback = fallback;
    }

    public Class<?> getFallbackFactory() {
        return this.fallbackFactory;
    }

    public void setFallbackFactory(Class<?> fallbackFactory) {
        this.fallbackFactory = fallbackFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.applicationContext = context;
        this.beanFactory = context;
    }
}

