/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sdk.spring.proxy;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Objects;
import org.apache.shenyu.common.utils.JsonUtils;
import org.apache.shenyu.sdk.core.ShenyuRequest;
import org.apache.shenyu.sdk.core.ShenyuResponse;
import org.apache.shenyu.sdk.core.client.ShenyuSdkClient;
import org.apache.shenyu.sdk.core.common.RequestTemplate;
import org.apache.shenyu.sdk.spring.ShenyuClient;
import org.apache.shenyu.sdk.spring.factory.AnnotatedParameterProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpClientErrorException;

public class ShenyuClientMethodHandler {
    private static final Logger log = LoggerFactory.getLogger(ShenyuClientMethodHandler.class);
    private final ShenyuClient shenyuClient;
    private final ShenyuSdkClient shenyuHttpClient;
    private final RequestTemplate requestTemplate;
    private final Map<Class<? extends Annotation>, AnnotatedParameterProcessor> annotatedArgumentProcessors;

    public ShenyuClientMethodHandler(ShenyuClient shenyuClient, RequestTemplate requestTemplate, ShenyuSdkClient shenyuHttpClient, Map<Class<? extends Annotation>, AnnotatedParameterProcessor> annotatedArgumentProcessors) {
        this.shenyuClient = shenyuClient;
        this.requestTemplate = requestTemplate;
        this.shenyuHttpClient = shenyuHttpClient;
        this.annotatedArgumentProcessors = annotatedArgumentProcessors;
    }

    public Object invoke(Object[] args) throws IOException {
        ShenyuRequest shenyuRequest = this.targetProcessor(this.requestTemplate, args);
        ShenyuResponse shenyuResponse = this.shenyuHttpClient.execute(shenyuRequest);
        return this.handlerResponse(shenyuResponse, shenyuRequest.getRequestTemplate().getReturnType());
    }

    private Object handlerResponse(ShenyuResponse shenyuResponse, Class<?> returnType) {
        if (Objects.isNull(shenyuResponse) || Void.TYPE == returnType) {
            return null;
        }
        if (ShenyuResponse.class == returnType) {
            return shenyuResponse;
        }
        if (shenyuResponse.getStatus() != HttpStatus.OK.value()) {
            log.warn("handlerResponse http status warn shenyuResponse {}", (Object)JsonUtils.toJson((Object)shenyuResponse));
            throw new HttpClientErrorException((HttpStatusCode)HttpStatus.valueOf((int)shenyuResponse.getStatus()));
        }
        if (StringUtils.hasText((String)shenyuResponse.getBody())) {
            return JsonUtils.jsonToObject((String)shenyuResponse.getBody(), returnType);
        }
        return null;
    }

    private ShenyuRequest targetProcessor(RequestTemplate requestTemplate, Object[] args) {
        RequestTemplate requestTemplateFrom = RequestTemplate.from((RequestTemplate)requestTemplate);
        ShenyuRequest request = requestTemplateFrom.request();
        for (RequestTemplate.ParamMetadata paramMetadata : requestTemplateFrom.getParamMetadataList()) {
            Annotation[] paramAnnotations;
            for (Annotation paramAnnotation : paramAnnotations = paramMetadata.getParamAnnotations()) {
                AnnotatedParameterProcessor processor = this.annotatedArgumentProcessors.get(paramAnnotation.annotationType());
                if (ObjectUtils.isEmpty((Object)processor)) continue;
                processor.processArgument(request, paramAnnotation, args[paramMetadata.getParamIndexOnMethod()]);
            }
        }
        return request;
    }
}

