/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sdk.spring.annotation;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.sdk.core.ShenyuRequest;
import org.apache.shenyu.sdk.core.common.RequestTemplate;
import org.apache.shenyu.sdk.core.util.Util;
import org.apache.shenyu.sdk.spring.factory.AnnotatedParameterProcessor;
import org.springframework.web.bind.annotation.RequestHeader;

public class RequestHeaderParameterProcessor
implements AnnotatedParameterProcessor {
    private static final Class<RequestHeader> ANNOTATION = RequestHeader.class;

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return ANNOTATION;
    }

    @Override
    public boolean processArgument(ShenyuRequest shenyuRequest, Annotation annotation, Object arg) {
        String name = ANNOTATION.cast(annotation).value();
        RequestTemplate requestTemplate = shenyuRequest.getRequestTemplate();
        Util.checkState((boolean)Objects.nonNull(Strings.emptyToNull((String)name)), (String)"RequestHeader.value() was empty on parameter %s", (Object[])new Object[]{requestTemplate.getMethod().getName()});
        Map headers = shenyuRequest.getHeaders();
        if (arg instanceof Map) {
            ((Map)arg).forEach((key, value) -> {
                if (key instanceof String && value instanceof Collection) {
                    headers.put((String)key, (Collection)value);
                    shenyuRequest.setHeaders(headers);
                } else if (key instanceof String && value instanceof String) {
                    headers.compute((String)key, (header, old) -> {
                        if (CollectionUtils.isEmpty((Collection)old)) {
                            return Lists.newArrayList((Object[])new String[]{(String)value});
                        }
                        old.add((String)value);
                        return old;
                    });
                    shenyuRequest.setHeaders(headers);
                }
            });
        } else if (arg instanceof String) {
            Collection headerColl = Optional.ofNullable((Collection)headers.get(name)).orElseGet(ArrayList::new);
            headerColl.add((String)arg);
            headers.put(name, headerColl);
            shenyuRequest.setHeaders(headers);
        }
        return true;
    }
}

