/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sdk.feign;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.shenyu.common.enums.HttpSchemeEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.UriUtils;
import org.apache.shenyu.loadbalancer.entity.Upstream;
import org.apache.shenyu.loadbalancer.factory.LoadBalancerFactory;
import org.apache.shenyu.registry.api.ShenyuInstanceRegisterRepository;
import org.apache.shenyu.registry.api.config.RegisterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.DefaultServiceInstance;
import org.springframework.cloud.client.ServiceInstance;

public class ShenyuDiscoveryClient {
    private static final Logger LOG = LoggerFactory.getLogger(ShenyuDiscoveryClient.class);
    private final ShenyuInstanceRegisterRepository registerRepository;
    private final RegisterConfig registerConfig;
    private final String algorithm;
    private final String scheme;

    public ShenyuDiscoveryClient(RegisterConfig registerConfig) {
        this(null, registerConfig);
    }

    public ShenyuDiscoveryClient(ShenyuInstanceRegisterRepository registerRepository, RegisterConfig registerConfig) {
        this.registerRepository = registerRepository;
        this.registerConfig = registerConfig;
        Properties props = registerConfig.getProps();
        this.algorithm = props.getProperty("algorithm", "roundRobin");
        this.scheme = props.getProperty("scheme", HttpSchemeEnum.HTTP.getScheme());
    }

    public ServiceInstance getInstance(String serviceId) {
        URI uri;
        List upstreams;
        if (Objects.isNull(this.registerRepository)) {
            List<String> serverList = Arrays.asList(this.registerConfig.getServerLists().split(","));
            if (serverList.isEmpty()) {
                throw new ShenyuException("illegal param, serverLists configuration required if registerType equals local.");
            }
            upstreams = serverList.stream().map(serverAddress -> Upstream.builder().url(UriUtils.appendScheme((String)serverAddress, (String)this.scheme)).build()).collect(Collectors.toList());
        } else {
            List instanceRegisters = this.registerRepository.selectInstances(serviceId);
            if (ObjectUtils.isEmpty((Object)instanceRegisters)) {
                throw new ShenyuException("Gateway address not found from registry.");
            }
            upstreams = instanceRegisters.stream().map(instanceRegister -> {
                String instanceUrl = String.join((CharSequence)":", instanceRegister.getHost(), Integer.toString(instanceRegister.getPort()));
                return Upstream.builder().url(UriUtils.appendScheme((String)instanceUrl, (String)this.scheme)).build();
            }).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(upstreams)) {
            LOG.error("The serviceId that named {} could not load balanced to at least one upstream.", (Object)serviceId);
        }
        Upstream upstream = (Upstream)upstreams.get(0);
        if (CollectionUtils.isNotEmpty(upstreams) && upstreams.size() > 1) {
            upstream = LoadBalancerFactory.selector(upstreams, (String)this.algorithm, (String)"");
        }
        if (Objects.isNull(uri = UriUtils.createUri((String)upstream.getUrl()))) {
            throw new ShenyuException("Gateway address uri is not invalid.");
        }
        return new DefaultServiceInstance(upstream.getUrl(), serviceId, uri.getHost(), uri.getPort(), HttpSchemeEnum.HTTPS.getScheme().equals(this.scheme));
    }
}

