/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.sdk.feign;

import feign.Capability;
import feign.Client;
import feign.Request;
import feign.RequestTemplate;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import org.apache.shenyu.sdk.feign.ShenyuDiscoveryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerUriTools;
import org.springframework.cloud.openfeign.loadbalancer.FeignBlockingLoadBalancerClient;
import org.springframework.cloud.openfeign.loadbalancer.RetryableFeignBlockingLoadBalancerClient;
import org.springframework.util.Assert;

public final class ShenyuClientCapability
implements Capability {
    public static final ShenyuClientCapability INSTANCE = new ShenyuClientCapability();
    private static final Logger LOGGER = LoggerFactory.getLogger(ShenyuClientCapability.class);
    private BeanFactory beanFactory;

    private ShenyuClientCapability() {
    }

    public Client enrich(Client finalDelegate) {
        return (request, options) -> {
            Client delegate = finalDelegate;
            URI originalUri = URI.create(request.url());
            String serviceId = originalUri.getHost();
            Assert.state((boolean)Objects.nonNull(serviceId), (String)("Request URI does not contain a valid hostname: " + originalUri));
            if (finalDelegate instanceof FeignBlockingLoadBalancerClient) {
                delegate = ((FeignBlockingLoadBalancerClient)finalDelegate).getDelegate();
            } else if (finalDelegate instanceof RetryableFeignBlockingLoadBalancerClient) {
                delegate = ((RetryableFeignBlockingLoadBalancerClient)finalDelegate).getDelegate();
            }
            ShenyuDiscoveryClient shenyuDiscoveryClient = (ShenyuDiscoveryClient)this.beanFactory.getBean(ShenyuDiscoveryClient.class);
            ServiceInstance serviceInstance = shenyuDiscoveryClient.getInstance(serviceId);
            String reconstructedUrl = LoadBalancerUriTools.reconstructURI((ServiceInstance)serviceInstance, (URI)originalUri).toString();
            Request newRequest = this.buildRequest(request, reconstructedUrl);
            LOGGER.info("shenyuClientCapability enrich client execute Uri {} to {}", (Object)originalUri, (Object)reconstructedUrl);
            return delegate.execute(newRequest, options);
        };
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    private Request buildRequest(Request request, String reconstructedUrl) {
        return Request.create((Request.HttpMethod)request.httpMethod(), (String)reconstructedUrl, (Map)request.headers(), (byte[])request.body(), (Charset)request.charset(), (RequestTemplate)request.requestTemplate());
    }
}

