/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.client.api;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shenyu.common.timer.Timer;
import org.apache.shenyu.common.timer.TimerTask;
import org.apache.shenyu.common.timer.WheelTimerFactory;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.client.api.retry.FailureRegistryTask;
import org.apache.shenyu.register.common.dto.ApiDocRegisterDTO;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FailbackRegistryRepository
implements ShenyuClientRegisterRepository {
    private final Logger logger = LoggerFactory.getLogger(FailbackRegistryRepository.class);
    private final Map<String, Holder> concurrentHashMap = new ConcurrentHashMap<String, Holder>();
    private final Timer timer = WheelTimerFactory.getSharedTimer();

    @Override
    public void persistInterface(MetaDataRegisterDTO metadata) {
        try {
            this.doPersistInterface(metadata);
        }
        catch (Exception ex) {
            this.logger.warn("Failed to persistInterface {}, cause:{}", (Object)metadata, (Object)ex.getMessage());
            this.addFailureMetaDataRegister(metadata);
        }
    }

    @Override
    public void persistURI(URIRegisterDTO registerDTO) {
        try {
            this.doPersistURI(registerDTO);
        }
        catch (Exception ex) {
            this.logger.warn("Failed to persistURI {}, cause:{}", (Object)registerDTO, (Object)ex.getMessage());
            this.addFailureUriDataRegister(registerDTO);
        }
    }

    @Override
    public void persistApiDoc(ApiDocRegisterDTO registerDTO) {
        try {
            this.doPersistApiDoc(registerDTO);
        }
        catch (Exception ex) {
            this.logger.warn("Failed to persistApiDoc {}, cause:{}", (Object)registerDTO, (Object)ex.getMessage());
            this.addFailureApiDocRegister(registerDTO);
        }
    }

    protected abstract void doPersistApiDoc(ApiDocRegisterDTO var1);

    protected <T> void addFailureMetaDataRegister(T t) {
        if (t instanceof MetaDataRegisterDTO) {
            MetaDataRegisterDTO dto = (MetaDataRegisterDTO)t;
            String fullPath = dto.getRpcType() + "://" + dto.getHost() + ":" + dto.getPort() + dto.getPath();
            this.addToFail(new Holder(t, fullPath, "metadata"));
        }
    }

    protected <T> void addFailureUriDataRegister(T t) {
        if (t instanceof ApiDocRegisterDTO) {
            URIRegisterDTO dto = (URIRegisterDTO)t;
            String address = String.join((CharSequence)":", dto.getHost(), String.valueOf(dto.getPort()), dto.getRpcType());
            this.addToFail(new Holder(t, address, "uri"));
        }
    }

    protected <T> void addFailureApiDocRegister(T t) {
        if (t instanceof ApiDocRegisterDTO) {
            ApiDocRegisterDTO dto = (ApiDocRegisterDTO)t;
            String address = String.join((CharSequence)":", dto.getContextPath(), dto.getApiPath(), dto.getHttpMethod().toString(), dto.getRpcType());
            this.addToFail(new Holder(t, address, "apiDoc"));
        }
    }

    private <T> void addToFail(Holder t) {
        Holder oldObj = this.concurrentHashMap.get(t.getKey());
        if (Objects.nonNull(oldObj)) {
            return;
        }
        FailureRegistryTask registryTask = new FailureRegistryTask(t.getKey(), this);
        this.concurrentHashMap.put(t.getKey(), t);
        this.timer.add((TimerTask)registryTask);
        this.logger.warn("Add to failback and wait for execution, {}", (Object)t.getPath());
    }

    public void remove(String key) {
        this.concurrentHashMap.remove(key);
    }

    public void accept(String key) {
        String type;
        Holder holder = this.concurrentHashMap.get(key);
        if (Objects.isNull(holder)) {
            return;
        }
        switch (type = holder.getType()) {
            case "uri": {
                this.doPersistURI((URIRegisterDTO)holder.getObj());
                break;
            }
            case "metadata": {
                this.doPersistInterface((MetaDataRegisterDTO)holder.getObj());
                break;
            }
            case "apiDoc": {
                this.doPersistApiDoc((ApiDocRegisterDTO)holder.getObj());
                break;
            }
        }
    }

    protected abstract void doPersistURI(URIRegisterDTO var1);

    protected abstract void doPersistInterface(MetaDataRegisterDTO var1);

    private static class Holder {
        private final Object obj;
        private final String path;
        private final String type;

        Holder(Object obj, String path, String type) {
            this.obj = obj;
            this.path = path;
            this.type = type;
        }

        public Object getObj() {
            return this.obj;
        }

        public String getPath() {
            return this.path;
        }

        public String getType() {
            return this.type;
        }

        private String getKey() {
            return String.join((CharSequence)":", this.path, this.type);
        }
    }
}

