/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.protocol.mqtt;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttUnsubAckMessage;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import java.util.List;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.protocol.mqtt.MessageType;
import org.apache.shenyu.protocol.mqtt.repositories.SubscribeRepository;

public class Unsubscribe
extends MessageType {
    @Override
    public void unsubscribe(ChannelHandlerContext ctx, MqttUnsubscribeMessage msg) {
        if (this.isConnected()) {
            return;
        }
        List topics = msg.payload().topics();
        Channel channel = ctx.channel();
        ((SubscribeRepository)Singleton.INST.get(SubscribeRepository.class)).remove(topics, channel);
        int packetId = msg.variableHeader().messageId();
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.UNSUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttUnsubAckMessage mqttUnsubAckMessage = new MqttUnsubAckMessage(mqttFixedHeader, MqttMessageIdVariableHeader.from((int)packetId));
        channel.writeAndFlush((Object)mqttUnsubAckMessage);
    }
}

