/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.protocol.mqtt;

import org.apache.shenyu.protocol.mqtt.MqttContext;
import org.apache.shenyu.protocol.mqtt.utils.EncryptUtil;

public class MqttServerConfiguration {
    private int port = 9500;
    private int bossGroupThreadCount = 1;
    private int maxPayloadSize = 65536;
    private int workerGroupThreadCount = 12;
    private String userName = "shenyu";
    private String password = "shenyu";
    private Boolean isEncryptPassword = false;
    private String encryptMode;
    private String leakDetectorLevel = "DISABLED";

    public void afterPropertiesSet() {
        if (this.isEncryptPassword()) {
            this.setPassword(this.encryptPassword());
        }
        MqttContext context = new MqttContext();
        context.setPassword(this.getPassword());
        context.setPort(this.getPort());
        context.setMaxPayloadSize(this.getMaxPayloadSize());
        context.setUserName(this.getUserName());
        context.setWorkerGroupThreadCount(this.getWorkerGroupThreadCount());
        context.setLeakDetectorLevel(this.getLeakDetectorLevel());
    }

    private String encryptPassword() {
        return EncryptUtil.choose(this.getEncryptMode(), this.getPassword());
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getBossGroupThreadCount() {
        return this.bossGroupThreadCount;
    }

    public void setBossGroupThreadCount(int bossGroupThreadCount) {
        this.bossGroupThreadCount = bossGroupThreadCount;
    }

    public int getMaxPayloadSize() {
        return this.maxPayloadSize;
    }

    public void setMaxPayloadSize(int maxPayloadSize) {
        this.maxPayloadSize = maxPayloadSize;
    }

    public int getWorkerGroupThreadCount() {
        return this.workerGroupThreadCount;
    }

    public void setWorkerGroupThreadCount(int workerGroupThreadCount) {
        this.workerGroupThreadCount = workerGroupThreadCount;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isEncryptPassword() {
        return this.isEncryptPassword;
    }

    public void setEncryptPassword(boolean encryptPassword) {
        this.isEncryptPassword = encryptPassword;
    }

    public String getEncryptMode() {
        return this.encryptMode;
    }

    public void setEncryptMode(String encryptMode) {
        this.encryptMode = encryptMode;
    }

    public String getLeakDetectorLevel() {
        return this.leakDetectorLevel;
    }

    public void setLeakDetectorLevel(String leakDetectorLevel) {
        this.leakDetectorLevel = leakDetectorLevel;
    }
}

