/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.protocol.mqtt;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttUnsubscribeMessage;
import org.apache.shenyu.protocol.mqtt.AbstractMessageType;
import org.apache.shenyu.protocol.mqtt.Connect;
import org.apache.shenyu.protocol.mqtt.Disconnect;
import org.apache.shenyu.protocol.mqtt.PingReq;
import org.apache.shenyu.protocol.mqtt.PingResp;
import org.apache.shenyu.protocol.mqtt.Publish;
import org.apache.shenyu.protocol.mqtt.Subscribe;
import org.apache.shenyu.protocol.mqtt.Unsubscribe;

public class MessageType
implements AbstractMessageType {
    private volatile boolean connected;

    boolean isConnected() {
        return this.connected;
    }

    void setConnected(boolean connected) {
        this.connected = connected;
    }

    @Override
    public void connect(ChannelHandlerContext ctx, MqttConnectMessage msg) {
        new Connect().connect(ctx, msg);
    }

    @Override
    public void publish(ChannelHandlerContext ctx, MqttPublishMessage msg) {
        new Publish().publish(ctx, msg);
    }

    @Override
    public void subscribe(ChannelHandlerContext ctx, MqttSubscribeMessage msg) {
        new Subscribe().subscribe(ctx, msg);
    }

    @Override
    public void unsubscribe(ChannelHandlerContext ctx, MqttUnsubscribeMessage msg) {
        new Unsubscribe().unsubscribe(ctx, msg);
    }

    @Override
    public void pingReq(ChannelHandlerContext ctx) {
        new PingReq().pingReq(ctx);
    }

    @Override
    public void pingResp(ChannelHandlerContext ctx) {
        new PingResp().pingResp(ctx);
    }

    @Override
    public void disconnect(ChannelHandlerContext ctx) {
        new Disconnect().disconnect(ctx);
    }
}

