/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.protocol.mqtt;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttConnAckMessage;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttMessageBuilders;
import io.netty.handler.codec.mqtt.MqttVersion;
import io.netty.util.concurrent.GenericFutureListener;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.protocol.mqtt.MessageType;
import org.apache.shenyu.protocol.mqtt.MqttContext;
import org.apache.shenyu.protocol.mqtt.repositories.ChannelRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Connect
extends MessageType {
    private static final Logger LOG = LoggerFactory.getLogger(Connect.class);

    @Override
    public void connect(ChannelHandlerContext ctx, MqttConnectMessage msg) {
        byte[] passwordInBytes;
        String userName;
        String clientId = msg.payload().clientIdentifier();
        if (StringUtils.isEmpty((CharSequence)clientId)) {
            LOG.info("MQTT clientId can not be empty.");
            this.close(ctx, MqttConnectReturnCode.CONNECTION_REFUSED_IDENTIFIER_REJECTED);
            return;
        }
        if (!this.allowedProtocolVersion(msg)) {
            LOG.info("MQTT protocol version is not supported. clientId: {}", (Object)clientId);
            this.close(ctx, MqttConnectReturnCode.CONNECTION_REFUSED_UNACCEPTABLE_PROTOCOL_VERSION);
        }
        if (!MqttContext.isValid(userName = msg.payload().userName(), passwordInBytes = msg.payload().passwordInBytes())) {
            LOG.info("MQTT client verification failed, please check the username and password.");
            this.close(ctx, MqttConnectReturnCode.CONNECTION_REFUSED_BAD_USER_NAME_OR_PASSWORD);
            return;
        }
        ((ChannelRepository)Singleton.INST.get(ChannelRepository.class)).add(ctx.channel(), clientId);
        MqttConnAckMessage ackMessage = MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_ACCEPTED).sessionPresent(true).build();
        ctx.writeAndFlush((Object)ackMessage);
        this.setConnected(true);
    }

    private void close(ChannelHandlerContext ctx, MqttConnectReturnCode returnCode) {
        ctx.writeAndFlush((Object)this.wrong(returnCode));
        ctx.close().addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
    }

    private MqttConnAckMessage wrong(MqttConnectReturnCode returnCode) {
        return MqttMessageBuilders.connAck().returnCode(returnCode).sessionPresent(false).build();
    }

    private boolean allowedProtocolVersion(MqttConnectMessage msg) {
        return msg.variableHeader().version() == MqttVersion.MQTT_3_1.protocolLevel();
    }
}

