/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.wasm.base;

import io.github.kawamuray.wasmtime.Extern;
import io.github.kawamuray.wasmtime.Func;
import io.github.kawamuray.wasmtime.Store;
import io.github.kawamuray.wasmtime.WasmFunctions;
import io.github.kawamuray.wasmtime.WasmValType;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.result.ShenyuResultEnum;
import org.apache.shenyu.plugin.api.result.ShenyuResultWrap;
import org.apache.shenyu.plugin.api.utils.WebFluxResultUtils;
import org.apache.shenyu.plugin.base.AbstractShenyuPlugin;
import org.apache.shenyu.plugin.wasm.api.loader.WasmLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class AbstractShenyuWasmPlugin
extends AbstractShenyuPlugin {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractShenyuWasmPlugin.class);
    protected static final Map<Long, Argument> ARGUMENTS = new ConcurrentHashMap<Long, Argument>();
    protected static final String DO_EXECUTE_METHOD_NAME = "doExecute";
    protected static final String BEFORE_METHOD_NAME = "before";
    protected static final String AFTER_METHOD_NAME = "after";
    private final WasmLoader wasmLoader = new WasmLoader(((Object)((Object)this)).getClass(), this::initWasmCallJavaFunc);

    protected Map<String, Func> initWasmCallJavaFunc(Store<Void> store) {
        return null;
    }

    public ByteBuffer getBuffer() {
        return this.wasmLoader.getBuffer();
    }

    protected Mono<Void> doExecute(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
        return this.wasmLoader.getWasmExtern(DO_EXECUTE_METHOD_NAME).map(doExecute -> {
            Long argumentId = this.callWASI(exchange, chain, selector, rule, (Extern)doExecute);
            return this.doExecute(exchange, chain, selector, rule, argumentId);
        }).orElseGet(() -> {
            LOG.error("{} function not found in {}", (Object)DO_EXECUTE_METHOD_NAME, (Object)this.wasmLoader.getWasmName());
            exchange.getResponse().setStatusCode((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR);
            Object error = ShenyuResultWrap.error((ServerWebExchange)exchange, (ShenyuResultEnum)ShenyuResultEnum.WASM_FUNC_NOT_FOUND);
            return WebFluxResultUtils.result((ServerWebExchange)exchange, (Object)error);
        });
    }

    protected abstract Mono<Void> doExecute(ServerWebExchange var1, ShenyuPluginChain var2, SelectorData var3, RuleData var4, Long var5);

    private Long callWASI(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule, Extern doExecute) {
        Long argumentId = this.getArgumentId(exchange, chain, selector, rule);
        ARGUMENTS.put(argumentId, new Argument(exchange, chain, selector, rule));
        WasmFunctions.consumer((Store)this.wasmLoader.getStore(), (Func)doExecute.func(), (WasmValType)WasmValType.I64).accept((Object)argumentId);
        ARGUMENTS.remove(argumentId);
        return argumentId;
    }

    protected abstract Long getArgumentId(ServerWebExchange var1, ShenyuPluginChain var2, SelectorData var3, RuleData var4);

    public void before(ServerWebExchange exchange) {
        this.wasmLoader.getWasmExtern(BEFORE_METHOD_NAME).ifPresent(before -> this.callWASI(exchange, null, null, null, (Extern)before));
    }

    public void after(ServerWebExchange exchange) {
        this.wasmLoader.getWasmExtern(AFTER_METHOD_NAME).ifPresent(before -> this.callWASI(exchange, null, null, null, (Extern)before));
    }

    protected static final class Argument {
        private final ServerWebExchange exchange;
        private final ShenyuPluginChain chain;
        private final SelectorData selector;
        private final RuleData rule;

        private Argument(ServerWebExchange exchange, ShenyuPluginChain chain, SelectorData selector, RuleData rule) {
            this.exchange = exchange;
            this.chain = chain;
            this.selector = selector;
            this.rule = rule;
        }

        public ServerWebExchange getExchange() {
            return this.exchange;
        }

        public ShenyuPluginChain getChain() {
            return this.chain;
        }

        public SelectorData getSelector() {
            return this.selector;
        }

        public RuleData getRule() {
            return this.rule;
        }
    }
}

