/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.ratelimiter.handler;

import java.nio.ByteBuffer;
import java.util.List;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.ReactiveRedisCallback;
import org.springframework.data.redis.core.script.DefaultReactiveScriptExecutor;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.serializer.RedisElementReader;
import org.springframework.data.redis.serializer.RedisElementWriter;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ShenyuReactiveScriptExecutor<K>
extends DefaultReactiveScriptExecutor<K> {
    private static final Logger LOG = LoggerFactory.getLogger(ShenyuReactiveScriptExecutor.class);

    public ShenyuReactiveScriptExecutor(ReactiveRedisConnectionFactory connectionFactory, RedisSerializationContext<K, ?> serializationContext) {
        super(connectionFactory, serializationContext);
    }

    @NonNull
    public <T> Flux<T> execute(@NonNull RedisScript<T> script, @NonNull List<K> keys, @NonNull List<?> args, @NonNull RedisElementWriter<?> argsWriter, @NonNull RedisElementReader<T> resultReader) {
        Assert.notNull(script, (String)"RedisScript must not be null!");
        Assert.notNull(argsWriter, (String)"Argument Writer must not be null!");
        Assert.notNull(resultReader, (String)"Result Reader must not be null!");
        Assert.notNull(keys, (String)"Keys must not be null!");
        Assert.notNull(args, (String)"Args must not be null!");
        return this.execute(connection -> {
            ReturnType returnType = ReturnType.fromJavaType((Class)script.getResultType());
            ByteBuffer[] keysAndArgs = this.keysAndArgs(argsWriter, keys, args);
            int keySize = keys.size();
            return super.eval(connection, script, returnType, keySize, keysAndArgs, resultReader);
        });
    }

    private <T> Flux<T> execute(ReactiveRedisCallback<T> action) {
        Assert.notNull(action, (String)"Callback object must not be null");
        ReactiveRedisConnectionFactory factory = this.getConnectionFactory();
        return Flux.usingWhen((Publisher)Mono.fromSupplier(() -> ((ReactiveRedisConnectionFactory)factory).getReactiveConnection()), arg_0 -> action.doInRedis(arg_0), ReactiveRedisConnection::closeLater).doOnError(throwable -> LOG.error("Redis execute exception: {}", (Object)throwable.getMessage()));
    }
}

