/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.mock.util;

import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.shenyu.plugin.mock.util.RandomUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MockUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MockUtil.class);
    private static final String DEFAULT_FORMAT = "YYYY-MM-dd HH:mm:ss";
    private static final String[] DOMAIN_SUFFIX = new String[]{"com", "org", "cn", "com.cn", "top", "edu", "io"};

    private MockUtil() {
    }

    public static Boolean bool() {
        return RandomUtil.randomInt(0, 1) == 1;
    }

    public static int randomInt(int min, int max) {
        return RandomUtil.randomInt(min, max);
    }

    public static FormatDouble randomDouble(double min, double max, String ... format) {
        Double result = Math.random() * (max - min) + min;
        if (Objects.nonNull(format) && format.length != 0) {
            return new FormatDouble(result, format[0]);
        }
        return new FormatDouble(result);
    }

    public static String email() {
        return String.format("%s@%s.%s", RandomUtil.randomLowerLetterString(MockUtil.randomInt(5, 10)), RandomUtil.randomLowerLetterString(MockUtil.randomInt(3, 8)), DOMAIN_SUFFIX[MockUtil.randomInt(0, DOMAIN_SUFFIX.length - 1)]);
    }

    public static String phone() {
        StringBuilder builder = new StringBuilder("1");
        builder.append(RandomUtil.randomInt(3, 9));
        for (int i = 0; i < 9; ++i) {
            builder.append(RandomUtil.randomInt(0, 9));
        }
        return builder.toString();
    }

    public static String zh(int min, int max) {
        Random random = new Random();
        int len = random.nextInt(max - min - 1) + min;
        return RandomStringUtils.random((int)len, (int)19968, (int)40869, (boolean)false, (boolean)false);
    }

    public static String en(int min, int max) {
        return RandomStringUtils.random((int)RandomUtil.randomInt(min, max), (int)5, (int)129, (boolean)true, (boolean)false);
    }

    public static Object oneOf(Object ... data) {
        return data[RandomUtil.randomInt(0, data.length - 1)];
    }

    public static String current(String ... formats) {
        String format = DEFAULT_FORMAT;
        if (Objects.nonNull(formats) && formats.length != 0 && Objects.nonNull(formats[0])) {
            format = formats[0];
        }
        LocalDateTime now = LocalDateTime.now();
        try {
            return DateTimeFormatter.ofPattern(format).format(now);
        }
        catch (DateTimeException e) {
            LOG.warn("format fail,use default format :{}", (Object)DEFAULT_FORMAT);
            return DateTimeFormatter.ofPattern(DEFAULT_FORMAT).format(now);
        }
    }

    public static Object nowDate() {
        return LocalDate.now();
    }

    public static Object nowTime() {
        return LocalDateTime.now().toString();
    }

    public static Object[] array(Object item, int length) {
        Object[] array = new Object[length];
        Arrays.fill(array, item);
        return array;
    }

    public static class FormatDouble
    extends Number {
        private final Double val;
        private final String format;

        public FormatDouble(Double val, String format) {
            this.val = val;
            this.format = format;
        }

        public FormatDouble(Double val) {
            this.val = val;
            this.format = null;
        }

        public String toString() {
            if (Objects.isNull(this.format)) {
                return this.val.toString();
            }
            return String.format(this.format, this.val);
        }

        @Override
        public int intValue() {
            return this.val.intValue();
        }

        @Override
        public long longValue() {
            return this.val.longValue();
        }

        @Override
        public float floatValue() {
            return this.val.floatValue();
        }

        @Override
        public double doubleValue() {
            return this.val;
        }
    }
}

