/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.logging.elasticsearch.client;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch.core.bulk.BulkOperation;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.endpoints.BooleanResponse;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import co.elastic.clients.util.ObjectBuilder;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.shenyu.common.utils.LogUtils;
import org.apache.shenyu.plugin.logging.common.client.AbstractLogConsumeClient;
import org.apache.shenyu.plugin.logging.common.entity.ShenyuRequestLog;
import org.apache.shenyu.plugin.logging.elasticsearch.config.ElasticSearchLogCollectConfig;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;

public class ElasticSearchLogCollectClient
extends AbstractLogConsumeClient<ElasticSearchLogCollectConfig.ElasticSearchLogConfig, ShenyuRequestLog> {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchLogCollectClient.class);
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private RestClient restClient;
    private ElasticsearchTransport transport;
    private ElasticsearchClient client;
    private String indexName = "shenyu-access-logging";

    public void initClient0(@NonNull ElasticSearchLogCollectConfig.ElasticSearchLogConfig config) {
        RestClientBuilder builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(config.getHost(), Integer.parseInt(config.getPort()))});
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{config.getUsername()}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{config.getPassword()})) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(config.getUsername(), config.getPassword()));
            builder.setHttpClientConfigCallback(arg_0 -> ElasticSearchLogCollectClient.lambda$initClient0$0(config, (CredentialsProvider)credentialsProvider, arg_0));
        }
        this.restClient = builder.build();
        this.transport = new RestClientTransport(this.restClient, (JsonpMapper)new JacksonJsonpMapper());
        this.client = new ElasticsearchClient(this.transport);
        this.indexName = StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{config.getIndexName()}) ? config.getIndexName() : "shenyu-access-logging";
        LogUtils.info((Logger)LOG, (String)"init ElasticSearchLogCollectClient success", (Object[])new Object[0]);
        this.createOrUpdateIndexAlias(this.indexName);
    }

    public void consume0(@NonNull List<ShenyuRequestLog> logs) {
        String actualIndex = this.getActualIndexName();
        if (!this.existsIndex(actualIndex)) {
            this.createIndex(actualIndex);
            this.createOrUpdateIndexAlias(this.indexName);
        }
        ArrayList bulkOperations = new ArrayList();
        logs.forEach(log -> {
            try {
                bulkOperations.add((BulkOperation)new BulkOperation.Builder().create(d -> (ObjectBuilder)d.document(log).index(this.indexName)).build());
            }
            catch (Exception e) {
                LogUtils.error((Logger)LOG, (String)"add logs error: ", (Object[])new Object[]{e});
            }
        });
        try {
            this.client.bulk(e -> e.index(this.indexName).operations(bulkOperations));
        }
        catch (Exception e2) {
            LogUtils.error((Logger)LOG, (String)"elasticsearch store logs error: ", (Object[])new Object[]{e2});
        }
    }

    public boolean existsIndex(String indexName) {
        try {
            BooleanResponse existsResponse = this.client.indices().exists(c -> c.index(indexName, new String[0]));
            return existsResponse.value();
        }
        catch (Exception e) {
            LogUtils.error((Logger)LOG, (String)"fail to check the index exists, error:", (Object[])new Object[]{e});
            return true;
        }
    }

    public void createIndex(String indexName) {
        try {
            this.client.indices().create(c -> c.index(indexName));
        }
        catch (IOException e) {
            LogUtils.error((Logger)LOG, (String)"create index error:", (Object[])new Object[]{e});
        }
    }

    private String getActualIndexName() {
        String date = LocalDate.now().format(DATE_FORMAT);
        return String.format("%s-%s", this.indexName, date);
    }

    private void createOrUpdateIndexAlias(String aliasName) {
        try {
            String actualIndex = this.getActualIndexName();
            if (!this.existsIndex(actualIndex)) {
                this.createIndex(actualIndex);
                LogUtils.info((Logger)LOG, (String)"Created new date-based index: {}", (Object[])new Object[]{actualIndex});
            }
            this.client.indices().putAlias(r -> r.index(actualIndex, new String[0]).name(aliasName));
            LogUtils.info((Logger)LOG, (String)"Updated alias {} to point to index {}", (Object[])new Object[]{aliasName, actualIndex});
        }
        catch (Exception e) {
            LogUtils.error((Logger)LOG, (String)"Failed to create/update alias: ", (Object[])new Object[]{e});
        }
    }

    public void close0() {
        if (Objects.nonNull(this.restClient)) {
            try {
                this.transport.close();
            }
            catch (IOException e) {
                LogUtils.error((Logger)LOG, (String)"transport close has IOException : ", (Object[])new Object[]{e});
            }
            try {
                this.restClient.close();
            }
            catch (IOException e) {
                LogUtils.error((Logger)LOG, (String)"restClient close has IOException : ", (Object[])new Object[]{e});
            }
        }
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$initClient0$0(ElasticSearchLogCollectConfig.ElasticSearchLogConfig config, CredentialsProvider credentialsProvider, HttpAsyncClientBuilder asyncClientBuilder) {
        if (Boolean.FALSE.equals(config.getAuthCache())) {
            asyncClientBuilder.disableAuthCaching();
        }
        return asyncClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

