/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.cryptor.strategy;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.plugin.cryptor.handler.CryptorRuleHandler;
import org.apache.shenyu.plugin.cryptor.utils.CryptorUtil;
import org.apache.shenyu.plugin.cryptor.utils.JsonUtil;
import org.springframework.web.server.ServerWebExchange;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum MapTypeEnum {
    ALL("all"){

        @Override
        public String map(String originalBody, String modifiedBody, String fieldName) {
            JsonElement element = JsonParser.parseString((String)originalBody);
            JsonElement resultJe = JsonUtil.replaceJsonNode(element, new AtomicInteger(0), modifiedBody, Arrays.asList(fieldName.split("\\.")));
            return resultJe.toString();
        }

        @Override
        public String convert(String originalBody, CryptorRuleHandler ruleHandle, ServerWebExchange exchange) {
            if (!ruleHandle.getFieldNames().contains(",")) {
                return FIELD.convert(originalBody, ruleHandle, exchange);
            }
            List<Pair<String, String>> pairs = JsonUtil.parser(originalBody, Arrays.stream(ruleHandle.getFieldNames().split(",")).collect(Collectors.toSet()));
            if (CollectionUtils.isEmpty(pairs)) {
                return null;
            }
            return CryptorUtil.crypt(ruleHandle, pairs, originalBody, exchange);
        }
    }
    ,
    FIELD("field"){

        @Override
        public String map(String originalBody, String modifiedBody, String fieldName) {
            return modifiedBody;
        }

        @Override
        public String convert(String originalBody, CryptorRuleHandler ruleHandle, ServerWebExchange exchange) {
            if (ruleHandle.getFieldNames().contains(",")) {
                return ALL.convert(originalBody, ruleHandle, exchange);
            }
            String parseBody = JsonUtil.parser(originalBody, ruleHandle.getFieldNames());
            if (Objects.isNull(parseBody)) {
                return null;
            }
            return CryptorUtil.crypt(ruleHandle, parseBody, originalBody, exchange);
        }
    };

    private final String mapType;

    private MapTypeEnum(String mapType) {
        this.mapType = mapType;
    }

    public abstract String map(String var1, String var2, String var3);

    public String map(String originalBody, List<Pair<String, String>> modifiedPairs) {
        if (CollectionUtils.isEmpty(modifiedPairs)) {
            return originalBody;
        }
        String modifiedString = originalBody;
        for (Pair<String, String> pair : modifiedPairs) {
            modifiedString = ALL.map(modifiedString, (String)pair.getRight(), (String)pair.getLeft());
        }
        return modifiedString;
    }

    public abstract String convert(String var1, CryptorRuleHandler var2, ServerWebExchange var3);

    public String getMapType() {
        return this.mapType;
    }

    public static MapTypeEnum mapType(String mapType) {
        return Arrays.stream(MapTypeEnum.values()).filter(type -> type.getMapType().equalsIgnoreCase(mapType)).findFirst().orElse(ALL);
    }
}

