/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.common.config.ShenyuConfig;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.MatchModeEnum;
import org.apache.shenyu.common.enums.SelectorTypeEnum;
import org.apache.shenyu.common.enums.TrieCacheTypeEnum;
import org.apache.shenyu.common.utils.ListUtil;
import org.apache.shenyu.common.utils.LogUtils;
import org.apache.shenyu.plugin.api.ShenyuPlugin;
import org.apache.shenyu.plugin.api.ShenyuPluginChain;
import org.apache.shenyu.plugin.api.utils.SpringBeanUtils;
import org.apache.shenyu.plugin.base.cache.BaseDataCache;
import org.apache.shenyu.plugin.base.cache.MatchDataCache;
import org.apache.shenyu.plugin.base.condition.strategy.MatchStrategyFactory;
import org.apache.shenyu.plugin.base.trie.ShenyuTrie;
import org.apache.shenyu.plugin.base.trie.ShenyuTrieNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public abstract class AbstractShenyuPlugin
implements ShenyuPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractShenyuPlugin.class);
    private static final String URI_CONDITION_TYPE = "uri";
    private ShenyuTrie selectorTrie;
    private ShenyuTrie ruleTrie;
    private ShenyuConfig.SelectorMatchCache selectorMatchConfig;
    private ShenyuConfig.RuleMatchCache ruleMatchConfig;

    protected abstract Mono<Void> doExecute(ServerWebExchange var1, ShenyuPluginChain var2, SelectorData var3, RuleData var4);

    public Mono<Void> execute(ServerWebExchange exchange, ShenyuPluginChain chain) {
        this.initCacheConfig();
        String pluginName = this.named();
        PluginData pluginData = BaseDataCache.getInstance().obtainPluginData(pluginName);
        if (Objects.isNull(pluginData) || !pluginData.getEnabled().booleanValue()) {
            return chain.execute(exchange);
        }
        String path = this.getRawPath(exchange);
        List<SelectorData> selectors = BaseDataCache.getInstance().obtainSelectorData(pluginName);
        if (CollectionUtils.isEmpty(selectors)) {
            return this.handleSelectorIfNull(pluginName, exchange, chain);
        }
        SelectorData selectorData = this.obtainSelectorDataCacheIfEnabled(path);
        if (Objects.nonNull(selectorData) && StringUtils.isBlank((CharSequence)selectorData.getId())) {
            return this.handleSelectorIfNull(pluginName, exchange, chain);
        }
        if (Objects.isNull(selectorData) && Objects.isNull(selectorData = this.trieMatchSelector(exchange, pluginName, path)) && Objects.isNull(selectorData = this.defaultMatchSelector(exchange, selectors, path))) {
            return this.handleSelectorIfNull(pluginName, exchange, chain);
        }
        this.printLog(selectorData, pluginName);
        if (!selectorData.getContinued().booleanValue()) {
            return this.doExecute(exchange, chain, selectorData, this.defaultRuleData(selectorData));
        }
        List<RuleData> rules = BaseDataCache.getInstance().obtainRuleData(selectorData.getId());
        if (CollectionUtils.isEmpty(rules)) {
            return this.handleRuleIfNull(pluginName, exchange, chain);
        }
        if (selectorData.getType().intValue() == SelectorTypeEnum.FULL_FLOW.getCode()) {
            RuleData rule = rules.get(rules.size() - 1);
            this.printLog(rule, pluginName);
            return this.doExecute(exchange, chain, selectorData, rule);
        }
        RuleData ruleData = this.obtainRuleDataCacheIfEnabled(path);
        if (Objects.nonNull(ruleData) && Objects.isNull(ruleData.getId())) {
            return this.handleRuleIfNull(pluginName, exchange, chain);
        }
        if (Objects.isNull(ruleData) && Objects.isNull(ruleData = this.trieMatchRule(exchange, selectorData, path)) && Objects.isNull(ruleData = this.defaultMatchRule(exchange, rules, path))) {
            return this.handleRuleIfNull(pluginName, exchange, chain);
        }
        this.printLog(ruleData, pluginName);
        return this.doExecute(exchange, chain, selectorData, ruleData);
    }

    protected String getRawPath(ServerWebExchange exchange) {
        return exchange.getRequest().getURI().getRawPath();
    }

    private void initCacheConfig() {
        if (Objects.isNull(this.selectorMatchConfig) || Objects.isNull(this.ruleMatchConfig)) {
            ShenyuConfig shenyuConfig = (ShenyuConfig)SpringBeanUtils.getInstance().getBean(ShenyuConfig.class);
            this.selectorMatchConfig = shenyuConfig.getSelectorMatchCache();
            this.ruleMatchConfig = shenyuConfig.getRuleMatchCache();
        }
        if (Objects.isNull(this.selectorTrie) || Objects.isNull(this.ruleTrie)) {
            this.selectorTrie = (ShenyuTrie)SpringBeanUtils.getInstance().getBean(TrieCacheTypeEnum.SELECTOR.getTrieType());
            this.ruleTrie = (ShenyuTrie)SpringBeanUtils.getInstance().getBean(TrieCacheTypeEnum.RULE.getTrieType());
        }
    }

    private SelectorData obtainSelectorDataCacheIfEnabled(String path) {
        return this.selectorMatchConfig.getCache().getEnabled() != false ? MatchDataCache.getInstance().obtainSelectorData(this.named(), path) : null;
    }

    private RuleData obtainRuleDataCacheIfEnabled(String path) {
        return this.ruleMatchConfig.getCache().getEnabled() != false ? MatchDataCache.getInstance().obtainRuleData(this.named(), path) : null;
    }

    private void cacheSelectorData(String path, SelectorData selectorData) {
        boolean isUriCondition;
        if (Boolean.FALSE.equals(this.selectorMatchConfig.getCache().getEnabled()) || Objects.isNull(selectorData) || Boolean.TRUE.equals(selectorData.getMatchRestful())) {
            return;
        }
        int initialCapacity = this.selectorMatchConfig.getCache().getInitialCapacity();
        long maximumSize = this.selectorMatchConfig.getCache().getMaximumSize();
        if (StringUtils.isBlank((CharSequence)selectorData.getId())) {
            MatchDataCache.getInstance().cacheSelectorData(path, selectorData, initialCapacity, maximumSize);
            return;
        }
        List conditionList = selectorData.getConditionList();
        if (CollectionUtils.isNotEmpty((Collection)conditionList) && (isUriCondition = conditionList.stream().allMatch(v -> URI_CONDITION_TYPE.equals(v.getParamType())))) {
            MatchDataCache.getInstance().cacheSelectorData(path, selectorData, initialCapacity, maximumSize);
        }
    }

    private void cacheRuleData(String path, RuleData ruleData) {
        boolean isUriCondition;
        if (Boolean.FALSE.equals(this.ruleMatchConfig.getCache().getEnabled()) || Objects.isNull(ruleData) || Boolean.TRUE.equals(ruleData.getMatchRestful())) {
            return;
        }
        int initialCapacity = this.ruleMatchConfig.getCache().getInitialCapacity();
        long maximumSize = this.ruleMatchConfig.getCache().getMaximumSize();
        if (StringUtils.isBlank((CharSequence)ruleData.getId())) {
            MatchDataCache.getInstance().cacheRuleData(path, ruleData, initialCapacity, maximumSize);
            return;
        }
        List conditionList = ruleData.getConditionDataList();
        if (CollectionUtils.isNotEmpty((Collection)conditionList) && (isUriCondition = conditionList.stream().allMatch(v -> URI_CONDITION_TYPE.equals(v.getParamType())))) {
            MatchDataCache.getInstance().cacheRuleData(path, ruleData, initialCapacity, maximumSize);
        }
    }

    private RuleData defaultRuleData(SelectorData selectorData) {
        RuleData ruleData = new RuleData();
        ruleData.setSelectorId(selectorData.getId());
        ruleData.setPluginName(selectorData.getPluginName());
        ruleData.setId("default_rule");
        return ruleData;
    }

    protected Mono<Void> handleSelectorIfNull(String pluginName, ServerWebExchange exchange, ShenyuPluginChain chain) {
        return chain.execute(exchange);
    }

    protected Mono<Void> handleRuleIfNull(String pluginName, ServerWebExchange exchange, ShenyuPluginChain chain) {
        return chain.execute(exchange);
    }

    private Pair<Boolean, SelectorData> matchSelector(ServerWebExchange exchange, Collection<SelectorData> selectors) {
        List<SelectorData> filterCollectors = selectors.stream().filter(selector -> selector.getEnabled() != false && this.filterSelector((SelectorData)selector, exchange) != false).distinct().collect(Collectors.toList());
        if (filterCollectors.size() > 1) {
            return Pair.of((Object)Boolean.FALSE, (Object)this.manyMatchSelector(filterCollectors));
        }
        return Pair.of((Object)Boolean.TRUE, (Object)filterCollectors.stream().findFirst().orElse(null));
    }

    private SelectorData manyMatchSelector(List<SelectorData> filterCollectors) {
        Map<Integer, List<Pair>> collect = filterCollectors.stream().map(selector -> {
            boolean match = MatchModeEnum.match((Integer)selector.getMatchMode(), (MatchModeEnum)MatchModeEnum.AND);
            int sort = 0;
            if (match) {
                sort = selector.getConditionList().size();
            }
            return Pair.of((Object)sort, (Object)selector);
        }).collect(Collectors.groupingBy(Pair::getLeft));
        Integer max = Collections.max(collect.keySet());
        List<Pair> pairs = collect.get(max);
        return pairs.stream().map(Pair::getRight).min(Comparator.comparing(SelectorData::getSort)).orElse(null);
    }

    private Boolean filterSelector(SelectorData selector, ServerWebExchange exchange) {
        if (selector.getType().intValue() == SelectorTypeEnum.CUSTOM_FLOW.getCode()) {
            if (CollectionUtils.isEmpty((Collection)selector.getConditionList())) {
                return false;
            }
            return MatchStrategyFactory.match(selector.getMatchMode(), selector.getConditionList(), exchange);
        }
        return true;
    }

    private Pair<Boolean, RuleData> matchRule(ServerWebExchange exchange, Collection<RuleData> rules) {
        List<RuleData> filterRuleData = rules.stream().filter(rule -> this.filterRule((RuleData)rule, exchange)).distinct().collect(Collectors.toList());
        if (filterRuleData.size() > 1) {
            return Pair.of((Object)Boolean.FALSE, (Object)this.manyMatchRule(filterRuleData));
        }
        return Pair.of((Object)Boolean.TRUE, (Object)filterRuleData.stream().findFirst().orElse(null));
    }

    private RuleData manyMatchRule(List<RuleData> filterRuleData) {
        Map<Integer, List<Pair>> collect = filterRuleData.stream().map(rule -> {
            boolean match = MatchModeEnum.match((Integer)rule.getMatchMode(), (MatchModeEnum)MatchModeEnum.AND);
            int sort = 0;
            if (match) {
                sort = rule.getConditionDataList().size();
            }
            return Pair.of((Object)sort, (Object)rule);
        }).collect(Collectors.groupingBy(Pair::getLeft));
        Integer max = Collections.max(collect.keySet());
        List<Pair> pairs = collect.get(max);
        return pairs.stream().map(Pair::getRight).min(Comparator.comparing(RuleData::getSort)).orElse(null);
    }

    private Boolean filterRule(RuleData ruleData, ServerWebExchange exchange) {
        return ruleData.getEnabled() != false && MatchStrategyFactory.match(ruleData.getMatchMode(), ruleData.getConditionDataList(), exchange);
    }

    private SelectorData trieMatchSelector(ServerWebExchange exchange, String pluginName, String path) {
        if (!this.selectorMatchConfig.getTrie().getEnabled().booleanValue()) {
            return null;
        }
        SelectorData selectorData = null;
        ShenyuTrieNode shenyuTrieNode = this.selectorTrie.match(path, pluginName);
        if (Objects.nonNull(shenyuTrieNode)) {
            LogUtils.info((Logger)LOG, (String)"{} selector match path from shenyu trie, path:{}", (Object[])new Object[]{pluginName, path});
            List<?> collection = shenyuTrieNode.getPathCache().get(pluginName);
            if (CollectionUtils.isNotEmpty(collection)) {
                Pair selectorDataPair;
                if (collection.size() > 1) {
                    selectorDataPair = this.matchSelector(exchange, ListUtil.castList(collection, SelectorData.class::cast));
                } else {
                    Object selectorObj = collection.stream().findFirst().orElse(null);
                    SelectorData selector = Objects.nonNull(selectorObj) ? (SelectorData)selectorObj : null;
                    boolean cached = Objects.nonNull(selector) && selector.getConditionList().stream().allMatch(condition -> URI_CONDITION_TYPE.equals(condition.getParamType()));
                    selectorDataPair = Pair.of((Object)cached, (Object)selector);
                }
                selectorData = (SelectorData)selectorDataPair.getRight();
                if (((Boolean)selectorDataPair.getLeft()).booleanValue() && Objects.nonNull(selectorData)) {
                    this.cacheSelectorData(path, selectorData);
                }
            }
        }
        return selectorData;
    }

    private RuleData trieMatchRule(ServerWebExchange exchange, SelectorData selectorData, String path) {
        if (!this.ruleMatchConfig.getTrie().getEnabled().booleanValue()) {
            return null;
        }
        RuleData ruleData = null;
        ShenyuTrieNode shenyuTrieNode = this.ruleTrie.match(path, selectorData.getId());
        if (Objects.nonNull(shenyuTrieNode)) {
            LogUtils.info((Logger)LOG, (String)"{} rule match path from shenyu trie", (Object[])new Object[]{this.named()});
            List<?> collection = shenyuTrieNode.getPathCache().get(selectorData.getId());
            if (CollectionUtils.isNotEmpty(collection)) {
                Pair ruleDataPair;
                if (collection.size() > 1) {
                    ruleDataPair = this.matchRule(exchange, ListUtil.castList(collection, RuleData.class::cast));
                } else {
                    Object ruleObj = collection.stream().findFirst().orElse(null);
                    RuleData rule = Objects.nonNull(ruleObj) ? (RuleData)ruleObj : null;
                    boolean cached = Objects.nonNull(rule) && rule.getConditionDataList().stream().allMatch(condition -> URI_CONDITION_TYPE.equals(condition.getParamType()));
                    ruleDataPair = Pair.of((Object)cached, (Object)rule);
                }
                ruleData = (RuleData)ruleDataPair.getRight();
                if (((Boolean)ruleDataPair.getLeft()).booleanValue() && Objects.nonNull(ruleData)) {
                    this.cacheRuleData(path, ruleData);
                }
            }
        }
        return ruleData;
    }

    private SelectorData defaultMatchSelector(ServerWebExchange exchange, List<SelectorData> selectors, String path) {
        Pair<Boolean, SelectorData> matchSelectorPair = this.matchSelector(exchange, selectors);
        SelectorData selectorData = (SelectorData)matchSelectorPair.getRight();
        if (Objects.nonNull(selectorData)) {
            LogUtils.info((Logger)LOG, (String)"{} selector match success from default strategy", (Object[])new Object[]{this.named()});
            if (((Boolean)matchSelectorPair.getLeft()).booleanValue()) {
                this.cacheSelectorData(path, selectorData);
            }
            return selectorData;
        }
        if (((Boolean)matchSelectorPair.getLeft()).booleanValue()) {
            SelectorData emptySelectorData = SelectorData.builder().pluginName(this.named()).build();
            this.cacheSelectorData(path, emptySelectorData);
        }
        return null;
    }

    private RuleData defaultMatchRule(ServerWebExchange exchange, List<RuleData> rules, String path) {
        Pair<Boolean, RuleData> matchRulePair = this.matchRule(exchange, rules);
        RuleData ruleData = (RuleData)matchRulePair.getRight();
        if (Objects.nonNull(ruleData)) {
            LOG.info("{} rule match path from default strategy", (Object)this.named());
            if (((Boolean)matchRulePair.getLeft()).booleanValue()) {
                this.cacheRuleData(path, ruleData);
            }
            return ruleData;
        }
        if (((Boolean)matchRulePair.getLeft()).booleanValue()) {
            RuleData emptyRuleData = RuleData.builder().pluginName(this.named()).build();
            this.cacheRuleData(path, emptyRuleData);
        }
        return null;
    }

    private void printLog(SelectorData selectorData, String pluginName) {
        if (selectorData.getLogged().booleanValue()) {
            LOG.info("{} selector success match , selector name :{}", (Object)pluginName, (Object)selectorData.getName());
        }
    }

    private void printLog(RuleData ruleData, String pluginName) {
        if (ruleData.getLoged().booleanValue()) {
            LOG.info("{} rule success match , rule name :{}", (Object)pluginName, (Object)ruleData.getName());
        }
    }
}

