/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base.support;

import java.util.function.Function;
import org.apache.shenyu.plugin.base.utils.ResponseUtils;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.util.annotation.NonNull;

public class ResponseDecorator
extends ServerHttpResponseDecorator {
    private final ServerWebExchange exchange;
    private final Function<String, String> convert;

    public ResponseDecorator(ServerWebExchange exchange, Function<String, String> convert) {
        super(exchange.getResponse());
        this.exchange = exchange;
        this.convert = convert;
    }

    @NonNull
    public Mono<Void> writeWith(@NonNull Publisher<? extends DataBuffer> body) {
        ClientResponse clientResponse = ResponseUtils.buildClientResponse(this.getDelegate(), body);
        Mono mono = clientResponse.bodyToMono(String.class).map(this.convert);
        return ResponseUtils.writeWith(clientResponse, this.exchange, mono, String.class);
    }
}

