/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.base.cache;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.enums.PluginHandlerEventEnum;
import org.apache.shenyu.common.enums.RuleTrieEventEnum;
import org.apache.shenyu.plugin.api.utils.SpringBeanUtils;
import org.apache.shenyu.plugin.base.cache.BaseDataCache;
import org.apache.shenyu.plugin.base.cache.MatchDataCache;
import org.apache.shenyu.plugin.base.cache.PluginHandlerEvent;
import org.apache.shenyu.plugin.base.event.RuleTrieEvent;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.base.trie.ShenyuTrie;
import org.apache.shenyu.sync.data.api.PluginDataSubscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.lang.NonNull;

public class CommonPluginDataSubscriber
implements PluginDataSubscriber {
    private static final Logger LOG = LoggerFactory.getLogger(CommonPluginDataSubscriber.class);
    private final Map<String, PluginDataHandler> handlerMap;
    private ApplicationEventPublisher eventPublisher;

    public CommonPluginDataSubscriber(List<PluginDataHandler> pluginDataHandlerList) {
        this.handlerMap = pluginDataHandlerList.stream().collect(Collectors.toConcurrentMap(PluginDataHandler::pluginNamed, e -> e));
    }

    public CommonPluginDataSubscriber(List<PluginDataHandler> pluginDataHandlerList, ApplicationEventPublisher eventPublisher) {
        this.handlerMap = pluginDataHandlerList.stream().collect(Collectors.toConcurrentMap(PluginDataHandler::pluginNamed, e -> e));
        this.eventPublisher = eventPublisher;
    }

    public void putExtendPluginDataHandler(List<PluginDataHandler> handlers) {
        if (CollectionUtils.isEmpty(handlers)) {
            return;
        }
        for (PluginDataHandler handler : handlers) {
            String pluginNamed = handler.pluginNamed();
            this.handlerMap.computeIfAbsent(pluginNamed, name -> {
                LOG.info("shenyu auto add extends plugin data handler name is :{}", (Object)pluginNamed);
                return handler;
            });
        }
    }

    public void onSubscribe(PluginData pluginData) {
        this.subscribeDataHandler(pluginData, DataEventTypeEnum.UPDATE);
    }

    public void unSubscribe(PluginData pluginData) {
        this.subscribeDataHandler(pluginData, DataEventTypeEnum.DELETE);
    }

    public void refreshPluginDataAll() {
        BaseDataCache.getInstance().cleanPluginData();
    }

    public void refreshPluginDataSelf(List<PluginData> pluginDataList) {
        if (CollectionUtils.isEmpty(pluginDataList)) {
            return;
        }
        BaseDataCache.getInstance().cleanPluginDataSelf(pluginDataList);
    }

    public void onSelectorSubscribe(SelectorData selectorData) {
        this.subscribeDataHandler(selectorData, DataEventTypeEnum.UPDATE);
    }

    public void unSelectorSubscribe(SelectorData selectorData) {
        this.subscribeDataHandler(selectorData, DataEventTypeEnum.DELETE);
    }

    public void refreshSelectorDataAll() {
        BaseDataCache.getInstance().cleanSelectorData();
        MatchDataCache.getInstance().cleanSelectorData();
    }

    public void refreshSelectorDataSelf(List<SelectorData> selectorDataList) {
        if (CollectionUtils.isEmpty(selectorDataList)) {
            return;
        }
        BaseDataCache.getInstance().cleanSelectorDataSelf(selectorDataList);
    }

    public void onRuleSubscribe(RuleData ruleData) {
        this.subscribeDataHandler(ruleData, DataEventTypeEnum.UPDATE);
    }

    public void unRuleSubscribe(RuleData ruleData) {
        this.subscribeDataHandler(ruleData, DataEventTypeEnum.DELETE);
    }

    public void refreshRuleDataAll() {
        BaseDataCache.getInstance().cleanRuleData();
        ((ShenyuTrie)SpringBeanUtils.getInstance().getBean(ShenyuTrie.class)).clear();
    }

    public void refreshRuleDataSelf(List<RuleData> ruleDataList) {
        if (CollectionUtils.isEmpty(ruleDataList)) {
            return;
        }
        BaseDataCache.getInstance().cleanRuleDataSelf(ruleDataList);
    }

    private <T> void subscribeDataHandler(T classData, DataEventTypeEnum dataType) {
        if (dataType == DataEventTypeEnum.UPDATE) {
            Optional.ofNullable(classData).ifPresent(data -> this.updateCacheData(classData));
        } else if (dataType == DataEventTypeEnum.DELETE) {
            Optional.ofNullable(classData).ifPresent(data -> this.removeCacheData(classData));
        }
    }

    private <T> void updateCacheData(@NonNull T data) {
        if (data instanceof PluginData) {
            PluginData pluginData = (PluginData)data;
            PluginData oldPluginData = BaseDataCache.getInstance().obtainPluginData(pluginData.getName());
            BaseDataCache.getInstance().cachePluginData(pluginData);
            Optional.ofNullable(this.handlerMap.get(pluginData.getName())).ifPresent(handler -> handler.handlerPlugin(pluginData));
            PluginHandlerEventEnum state = Boolean.TRUE.equals(pluginData.getEnabled()) ? PluginHandlerEventEnum.ENABLED : PluginHandlerEventEnum.DISABLED;
            this.eventPublisher.publishEvent((ApplicationEvent)new PluginHandlerEvent(state, pluginData));
            this.sortPluginIfOrderChange(oldPluginData, pluginData);
        } else if (data instanceof SelectorData) {
            SelectorData selectorData = (SelectorData)data;
            BaseDataCache.getInstance().cacheSelectData(selectorData);
            MatchDataCache.getInstance().removeSelectorData(selectorData.getPluginName());
            Optional.ofNullable(this.handlerMap.get(selectorData.getPluginName())).ifPresent(handler -> handler.handlerSelector(selectorData));
        } else if (data instanceof RuleData) {
            RuleData ruleData = (RuleData)data;
            BaseDataCache.getInstance().cacheRuleData(ruleData);
            Optional.ofNullable(this.handlerMap.get(ruleData.getPluginName())).ifPresent(handler -> handler.handlerRule(ruleData));
            this.eventPublisher.publishEvent((ApplicationEvent)new RuleTrieEvent(RuleTrieEventEnum.INSERT, ruleData));
        }
    }

    private void sortPluginIfOrderChange(PluginData oldPluginData, PluginData pluginData) {
        if (Objects.isNull(this.eventPublisher) || Objects.isNull(pluginData.getSort())) {
            return;
        }
        if (Objects.isNull(oldPluginData) || Objects.isNull(oldPluginData.getSort()) || !Objects.equals(oldPluginData.getSort(), pluginData.getSort())) {
            this.eventPublisher.publishEvent((ApplicationEvent)new PluginHandlerEvent(PluginHandlerEventEnum.SORTED, pluginData));
        }
    }

    private <T> void removeCacheData(@NonNull T data) {
        if (data instanceof PluginData) {
            PluginData pluginData = (PluginData)data;
            BaseDataCache.getInstance().removePluginData(pluginData);
            Optional.ofNullable(this.handlerMap.get(pluginData.getName())).ifPresent(handler -> handler.removePlugin(pluginData));
            this.eventPublisher.publishEvent((ApplicationEvent)new PluginHandlerEvent(PluginHandlerEventEnum.DELETE, pluginData));
        } else if (data instanceof SelectorData) {
            SelectorData selectorData = (SelectorData)data;
            BaseDataCache.getInstance().removeSelectData(selectorData);
            MatchDataCache.getInstance().removeSelectorData(selectorData.getPluginName());
            Optional.ofNullable(this.handlerMap.get(selectorData.getPluginName())).ifPresent(handler -> handler.removeSelector(selectorData));
        } else if (data instanceof RuleData) {
            RuleData ruleData = (RuleData)data;
            BaseDataCache.getInstance().removeRuleData(ruleData);
            Optional.ofNullable(this.handlerMap.get(ruleData.getPluginName())).ifPresent(handler -> handler.removeRule(ruleData));
            this.eventPublisher.publishEvent((ApplicationEvent)new RuleTrieEvent(RuleTrieEventEnum.REMOVE, ruleData));
        }
    }
}

