/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.k8s.parser;

import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1HTTPIngressPath;
import io.kubernetes.client.openapi.models.V1Ingress;
import io.kubernetes.client.openapi.models.V1IngressBackend;
import io.kubernetes.client.openapi.models.V1IngressRule;
import io.kubernetes.client.openapi.models.V1IngressTLS;
import io.kubernetes.client.openapi.models.V1Secret;
import io.kubernetes.client.openapi.models.V1Service;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.common.config.ssl.SslCrtAndKeyStream;
import org.apache.shenyu.common.dto.ConditionData;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.impl.SofaRuleHandle;
import org.apache.shenyu.common.enums.LoadBalanceEnum;
import org.apache.shenyu.common.enums.MatchModeEnum;
import org.apache.shenyu.common.enums.OperatorEnum;
import org.apache.shenyu.common.enums.ParamTypeEnum;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.enums.SelectorTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.k8s.common.IngressConfiguration;
import org.apache.shenyu.k8s.common.ShenyuMemoryConfig;
import org.apache.shenyu.k8s.parser.K8sResourceParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SofaParser
implements K8sResourceParser<V1Ingress> {
    private static final Logger LOG = LoggerFactory.getLogger(SofaParser.class);
    private final Lister<V1Service> serviceLister;
    private final Lister<V1Endpoints> endpointsLister;

    public SofaParser(Lister<V1Service> serviceInformer, Lister<V1Endpoints> endpointsInformer) {
        this.serviceLister = serviceInformer;
        this.endpointsLister = endpointsInformer;
    }

    @Override
    public ShenyuMemoryConfig parse(V1Ingress ingress, CoreV1Api coreV1Api) {
        ShenyuMemoryConfig res = new ShenyuMemoryConfig();
        if (Objects.nonNull(ingress.getSpec())) {
            V1IngressBackend sofaBackend = ingress.getSpec().getDefaultBackend();
            List rules = ingress.getSpec().getRules();
            List tlsList = ingress.getSpec().getTls();
            String namespace = Objects.requireNonNull(ingress.getMetadata()).getNamespace();
            if (Objects.isNull(rules) || CollectionUtils.isEmpty((Collection)rules)) {
                if (Objects.nonNull(sofaBackend) && Objects.nonNull(sofaBackend.getService())) {
                    IngressConfiguration defaultRouteConfig = this.getSofaRouteConfig(ingress.getMetadata().getAnnotations());
                    res.setGlobalDefaultBackend((Pair<Pair<String, String>, IngressConfiguration>)Pair.of((Object)Pair.of((Object)(namespace + "/" + ingress.getMetadata().getName()), (Object)sofaBackend.getService().getName()), (Object)defaultRouteConfig));
                }
            } else {
                ArrayList<IngressConfiguration> routeList = new ArrayList<IngressConfiguration>(rules.size());
                for (V1IngressRule ingressRule : rules) {
                    List<IngressConfiguration> routes = this.parseIngressRule(ingressRule, Objects.requireNonNull(ingress.getMetadata()).getNamespace(), ingress.getMetadata().getAnnotations(), ingress.getMetadata().getLabels());
                    routeList.addAll(routes);
                }
                res.setRouteConfigList(routeList);
            }
            if (Objects.nonNull(tlsList) && CollectionUtils.isNotEmpty((Collection)tlsList)) {
                ArrayList<SslCrtAndKeyStream> sslList = new ArrayList<SslCrtAndKeyStream>();
                for (V1IngressTLS tls : tlsList) {
                    if (!Objects.nonNull(tls.getSecretName()) || !Objects.nonNull(tls.getHosts()) || !CollectionUtils.isNotEmpty((Collection)tls.getHosts())) continue;
                    try {
                        V1Secret secret = coreV1Api.readNamespacedSecret(tls.getSecretName(), namespace, "ture");
                        Map secretData = secret.getData();
                        if (!MapUtils.isNotEmpty((Map)secretData)) continue;
                        ByteArrayInputStream keyCertChainInputStream = new ByteArrayInputStream((byte[])secretData.get("tls.crt"));
                        ByteArrayInputStream keyInputStream = new ByteArrayInputStream((byte[])secretData.get("tls.key"));
                        tls.getHosts().forEach(host -> sslList.add(new SslCrtAndKeyStream(host, keyCertChainInputStream, keyInputStream)));
                    }
                    catch (ApiException e) {
                        LOG.error("parse tls failed ", (Throwable)e);
                    }
                }
                res.setTlsConfigList(sslList);
            }
        }
        return res;
    }

    private List<IngressConfiguration> parseIngressRule(V1IngressRule ingressRule, String namespace, Map<String, String> annotations, Map<String, String> labels) {
        List paths;
        ConditionData hostCondition;
        ArrayList<IngressConfiguration> res = new ArrayList<IngressConfiguration>();
        ConditionData conditionData = hostCondition = Objects.nonNull(ingressRule.getHost()) ? this.createHostCondition(ingressRule.getHost()) : null;
        if (Objects.nonNull(ingressRule.getHttp()) && Objects.nonNull(paths = ingressRule.getHttp().getPaths())) {
            for (V1HTTPIngressPath path : paths) {
                if (Objects.isNull(path.getPath())) continue;
                OperatorEnum operator = this.getOperator(path.getPathType());
                ConditionData pathCondition = this.createPathCondition(path.getPath(), operator);
                ArrayList<ConditionData> conditionList = new ArrayList<ConditionData>(2);
                if (Objects.nonNull(hostCondition)) {
                    conditionList.add(hostCondition);
                }
                conditionList.add(pathCondition);
                SelectorData selectorData = this.createSelectorData(path.getPath(), conditionList);
                ArrayList<RuleData> ruleDataList = new ArrayList<RuleData>();
                ArrayList<MetaData> metaDataList = new ArrayList<MetaData>();
                for (String label : labels.keySet()) {
                    Map metadataAnnotations = ((V1Service)this.serviceLister.namespace(namespace).get(labels.get(label))).getMetadata().getAnnotations();
                    SofaRuleHandle ruleHandle = this.createSofaRuleHandle(annotations);
                    List<ConditionData> ruleConditionList = this.getRuleConditionList(metadataAnnotations);
                    RuleData ruleData = this.createRuleData(metadataAnnotations, ruleHandle, ruleConditionList);
                    MetaData metaData = this.parseMetaData(metadataAnnotations);
                    ruleDataList.add(ruleData);
                    metaDataList.add(metaData);
                }
                res.add(new IngressConfiguration(selectorData, ruleDataList, metaDataList));
            }
        }
        return res;
    }

    private List<ConditionData> getRuleConditionList(Map<String, String> annotations) {
        ArrayList<ConditionData> ruleConditionList = new ArrayList<ConditionData>();
        ConditionData ruleCondition = new ConditionData();
        ruleCondition.setOperator(OperatorEnum.EQ.getAlias());
        ruleCondition.setParamType(ParamTypeEnum.URI.getName());
        ruleCondition.setParamValue(annotations.get("shenyu.apache.org/plugin-sofa-path"));
        ruleConditionList.add(ruleCondition);
        return ruleConditionList;
    }

    private ConditionData createHostCondition(String host) {
        ConditionData hostCondition = new ConditionData();
        hostCondition.setParamType(ParamTypeEnum.DOMAIN.getName());
        hostCondition.setOperator(OperatorEnum.EQ.getAlias());
        hostCondition.setParamValue(host);
        return hostCondition;
    }

    private OperatorEnum getOperator(String pathType) {
        if ("ImplementationSpecific".equals(pathType)) {
            return OperatorEnum.MATCH;
        }
        if ("Prefix".equals(pathType)) {
            return OperatorEnum.STARTS_WITH;
        }
        if ("Exact".equals(pathType)) {
            return OperatorEnum.EQ;
        }
        LOG.info("Invalid path type, set it with match operator");
        return OperatorEnum.MATCH;
    }

    private ConditionData createPathCondition(String path, OperatorEnum operator) {
        ConditionData pathCondition = new ConditionData();
        pathCondition.setOperator(operator.getAlias());
        pathCondition.setParamType(ParamTypeEnum.URI.getName());
        pathCondition.setParamValue(path);
        return pathCondition;
    }

    private SofaRuleHandle createSofaRuleHandle(Map<String, String> annotations) {
        SofaRuleHandle sofaRuleHandle = new SofaRuleHandle();
        if (Objects.nonNull(annotations)) {
            sofaRuleHandle.setLoadBalance(annotations.getOrDefault("shenyu.apache.org/loadbalancer", LoadBalanceEnum.RANDOM.getName()));
            sofaRuleHandle.setTimeout(Long.parseLong(annotations.getOrDefault("shenyu.apache.org/timeout", "3000")));
            sofaRuleHandle.setRetries(Integer.valueOf(Integer.parseInt(annotations.getOrDefault("shenyu.apache.org/retry", "3"))));
        }
        return sofaRuleHandle;
    }

    private SelectorData createSelectorData(String path, List<ConditionData> conditionList) {
        return SelectorData.builder().pluginId(String.valueOf(PluginEnum.SOFA.getCode())).pluginName(PluginEnum.SOFA.getName()).name(path).matchMode(Integer.valueOf(MatchModeEnum.AND.getCode())).type(Integer.valueOf(SelectorTypeEnum.CUSTOM_FLOW.getCode())).enabled(Boolean.valueOf(true)).logged(Boolean.valueOf(false)).continued(Boolean.valueOf(true)).conditionList(conditionList).build();
    }

    private RuleData createRuleData(Map<String, String> metadataAnnotations, SofaRuleHandle ruleHandle, List<ConditionData> ruleConditionList) {
        return RuleData.builder().name(metadataAnnotations.get("shenyu.apache.org/plugin-sofa-path")).pluginName(PluginEnum.SOFA.getName()).matchMode(Integer.valueOf(MatchModeEnum.AND.getCode())).conditionDataList(ruleConditionList).handle(GsonUtils.getInstance().toJson((Object)ruleHandle)).loged(Boolean.valueOf(true)).enabled(Boolean.valueOf(true)).build();
    }

    private MetaData parseMetaData(Map<String, String> annotations) {
        return MetaData.builder().appName(annotations.get("shenyu.apache.org/plugin-sofa-app-name")).path(annotations.get("shenyu.apache.org/plugin-sofa-path")).rpcType(annotations.get("shenyu.apache.org/plugin-sofa-rpc-type")).rpcExt(annotations.get("shenyu.apache.org/plugin-sofa-rpc-expand")).serviceName(annotations.get("shenyu.apache.org/plugin-sofa-service-name")).methodName(annotations.get("shenyu.apache.org/plugin-sofa-method-name")).parameterTypes(annotations.get("shenyu.apache.org/plugin-sofa-params-type")).enabled(Boolean.valueOf(true)).build();
    }

    private IngressConfiguration getSofaRouteConfig(Map<String, String> annotations) {
        ConditionData conditionData = new ConditionData();
        conditionData.setParamName("sofa");
        conditionData.setParamType(ParamTypeEnum.URI.getName());
        conditionData.setOperator(OperatorEnum.PATH_PATTERN.getAlias());
        conditionData.setParamValue("/**");
        SelectorData selectorData = SelectorData.builder().name("sofa-selector").sort(Integer.valueOf(Integer.MAX_VALUE)).conditionList(Collections.singletonList(conditionData)).enabled(Boolean.valueOf(true)).id("1").pluginName(PluginEnum.SOFA.getName()).pluginId(String.valueOf(PluginEnum.SOFA.getCode())).logged(Boolean.valueOf(false)).continued(Boolean.valueOf(true)).matchMode(Integer.valueOf(MatchModeEnum.AND.getCode())).type(Integer.valueOf(SelectorTypeEnum.FULL_FLOW.getCode())).build();
        RuleData ruleData = RuleData.builder().selectorId("1").pluginName(PluginEnum.SOFA.getName()).name("sofa-rule").matchMode(Integer.valueOf(MatchModeEnum.AND.getCode())).conditionDataList(Collections.singletonList(conditionData)).loged(Boolean.valueOf(false)).enabled(Boolean.valueOf(true)).sort(Integer.valueOf(Integer.MAX_VALUE)).build();
        MetaData metaData = new MetaData();
        if (Objects.nonNull(annotations)) {
            metaData.setAppName(annotations.getOrDefault("shenyu.apache.org/plugin-sofa-app-name", "sofa"));
            metaData.setMethodName(annotations.getOrDefault("shenyu.apache.org/plugin-sofa-method-name", "methodName"));
            metaData.setPath(annotations.getOrDefault("shenyu.apache.org/plugin-sofa-path", "/sofa/findAll"));
            metaData.setRpcType(annotations.getOrDefault("shenyu.apache.org/plugin-sofa-rpc-type", RpcTypeEnum.SOFA.getName()));
            metaData.setServiceName(annotations.getOrDefault("shenyu.apache.org/plugin-sofa-service-name", "findAll"));
            metaData.setContextPath(annotations.getOrDefault("shenyu.apache.org/plugin-sofa-context-path", "/sofa"));
            metaData.setRpcExt(annotations.getOrDefault("shenyu.apache.org/plugin-sofa-rpc-ext", "{\"loadbalance\":\"hash\",\"retries\":3,\"timeout\":-1}"));
            metaData.setParameterTypes(annotations.getOrDefault("shenyu.apache.org/plugin-sofa-parameter-type", ""));
            metaData.setEnabled(Boolean.valueOf(Boolean.parseBoolean(annotations.getOrDefault("shenyu.apache.org/plugin-sofa-enabled", "true"))));
        }
        return new IngressConfiguration(selectorData, Arrays.asList(ruleData), Arrays.asList(metaData));
    }
}

