/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.k8s.parser;

import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1EndpointAddress;
import io.kubernetes.client.openapi.models.V1EndpointSubset;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1HTTPIngressPath;
import io.kubernetes.client.openapi.models.V1Ingress;
import io.kubernetes.client.openapi.models.V1IngressBackend;
import io.kubernetes.client.openapi.models.V1IngressRule;
import io.kubernetes.client.openapi.models.V1IngressServiceBackend;
import io.kubernetes.client.openapi.models.V1IngressTLS;
import io.kubernetes.client.openapi.models.V1Secret;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceBackendPort;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.common.config.ssl.SslCrtAndKeyStream;
import org.apache.shenyu.common.dto.ConditionData;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.rule.impl.GrpcRuleHandle;
import org.apache.shenyu.common.dto.convert.selector.GrpcUpstream;
import org.apache.shenyu.common.enums.LoadBalanceEnum;
import org.apache.shenyu.common.enums.MatchModeEnum;
import org.apache.shenyu.common.enums.OperatorEnum;
import org.apache.shenyu.common.enums.ParamTypeEnum;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.enums.SelectorTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.k8s.common.IngressConfiguration;
import org.apache.shenyu.k8s.common.ShenyuMemoryConfig;
import org.apache.shenyu.k8s.parser.K8sResourceParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcParser
implements K8sResourceParser<V1Ingress> {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcParser.class);
    private final Lister<V1Service> serviceLister;
    private final Lister<V1Endpoints> endpointsLister;

    public GrpcParser(Lister<V1Service> serviceInformer, Lister<V1Endpoints> endpointsInformer) {
        this.serviceLister = serviceInformer;
        this.endpointsLister = endpointsInformer;
    }

    @Override
    public ShenyuMemoryConfig parse(V1Ingress ingress, CoreV1Api coreV1Api) {
        ShenyuMemoryConfig res = new ShenyuMemoryConfig();
        if (Objects.nonNull(ingress.getSpec())) {
            V1IngressBackend grpcBackend = ingress.getSpec().getDefaultBackend();
            List rules = ingress.getSpec().getRules();
            List tlsList = ingress.getSpec().getTls();
            String namespace = Objects.requireNonNull(ingress.getMetadata()).getNamespace();
            List<GrpcUpstream> grpcDefaultUpstreamList = this.parseDefaultService(grpcBackend, namespace);
            if (Objects.isNull(rules) || CollectionUtils.isEmpty((Collection)rules)) {
                if (Objects.nonNull(grpcBackend) && Objects.nonNull(grpcBackend.getService())) {
                    IngressConfiguration defaultRouteConfig = this.getRpcRouteConfig(grpcDefaultUpstreamList, ingress.getMetadata().getAnnotations());
                    res.setGlobalDefaultBackend((Pair<Pair<String, String>, IngressConfiguration>)Pair.of((Object)Pair.of((Object)(namespace + "/" + ingress.getMetadata().getName()), (Object)grpcBackend.getService().getName()), (Object)defaultRouteConfig));
                }
            } else {
                ArrayList<IngressConfiguration> routeList = new ArrayList<IngressConfiguration>(rules.size());
                for (V1IngressRule ingressRule : rules) {
                    List<IngressConfiguration> routes = this.parseIngressRule(ingressRule, Objects.requireNonNull(ingress.getMetadata()).getNamespace(), ingress.getMetadata().getAnnotations(), ingress.getMetadata().getLabels());
                    routeList.addAll(routes);
                }
                res.setRouteConfigList(routeList);
            }
            if (Objects.nonNull(tlsList) && CollectionUtils.isNotEmpty((Collection)tlsList)) {
                ArrayList<SslCrtAndKeyStream> sslList = new ArrayList<SslCrtAndKeyStream>();
                for (V1IngressTLS tls : tlsList) {
                    if (!Objects.nonNull(tls.getSecretName()) || !Objects.nonNull(tls.getHosts()) || !CollectionUtils.isNotEmpty((Collection)tls.getHosts())) continue;
                    try {
                        V1Secret secret = coreV1Api.readNamespacedSecret(tls.getSecretName(), namespace, "ture");
                        if (!Objects.nonNull(secret.getData())) continue;
                        ByteArrayInputStream keyCertChainInputStream = new ByteArrayInputStream((byte[])secret.getData().get("tls.crt"));
                        ByteArrayInputStream keyInputStream = new ByteArrayInputStream((byte[])secret.getData().get("tls.key"));
                        tls.getHosts().forEach(host -> sslList.add(new SslCrtAndKeyStream(host, keyCertChainInputStream, keyInputStream)));
                    }
                    catch (ApiException e) {
                        LOG.error("parse tls failed ", (Throwable)e);
                    }
                }
                res.setTlsConfigList(sslList);
            }
        }
        return res;
    }

    private List<GrpcUpstream> parseDefaultService(V1IngressBackend defaultBackend, String namespace) {
        ArrayList<GrpcUpstream> defaultUpstreamList = new ArrayList<GrpcUpstream>();
        if (Objects.nonNull(defaultBackend) && Objects.nonNull(defaultBackend.getService())) {
            String serviceName = defaultBackend.getService().getName();
            V1Endpoints v1Endpoints = (V1Endpoints)this.endpointsLister.namespace(namespace).get(serviceName);
            List subsets = v1Endpoints.getSubsets();
            if (Objects.isNull(subsets) || CollectionUtils.isEmpty((Collection)subsets)) {
                LOG.info("Endpoints {} do not have subsets", (Object)serviceName);
            } else {
                for (V1EndpointSubset subset : subsets) {
                    List addresses = subset.getAddresses();
                    if (Objects.isNull(addresses) || CollectionUtils.isEmpty((Collection)addresses)) continue;
                    for (V1EndpointAddress address : addresses) {
                        String upstreamIp = address.getIp();
                        String defaultPort = this.parsePort(defaultBackend.getService());
                        if (!Objects.nonNull(defaultPort)) continue;
                        GrpcUpstream upstream = GrpcUpstream.builder().upstreamUrl(upstreamIp + ":" + defaultPort).weight(50).build();
                        defaultUpstreamList.add(upstream);
                    }
                }
            }
        }
        return defaultUpstreamList;
    }

    private List<GrpcUpstream> parseUpstream(V1IngressBackend backend, String namespace) {
        ArrayList<GrpcUpstream> upstreamList = new ArrayList<GrpcUpstream>();
        if (Objects.nonNull(backend) && Objects.nonNull(backend.getService()) && Objects.nonNull(backend.getService().getName())) {
            String serviceName = backend.getService().getName();
            V1Endpoints v1Endpoints = (V1Endpoints)this.endpointsLister.namespace(namespace).get(serviceName);
            List subsets = v1Endpoints.getSubsets();
            if (Objects.isNull(subsets) || CollectionUtils.isEmpty((Collection)subsets)) {
                LOG.info("Endpoints {} do not have subsets", (Object)serviceName);
            } else {
                for (V1EndpointSubset subset : subsets) {
                    List addresses = subset.getAddresses();
                    if (Objects.isNull(addresses) || addresses.isEmpty()) continue;
                    for (V1EndpointAddress address : addresses) {
                        String upstreamIp = address.getIp();
                        String defaultPort = this.parsePort(backend.getService());
                        if (!Objects.nonNull(defaultPort)) continue;
                        GrpcUpstream upstream = GrpcUpstream.builder().upstreamUrl(upstreamIp + ":" + defaultPort).weight(100).build();
                        upstreamList.add(upstream);
                    }
                }
            }
        }
        return upstreamList;
    }

    private String parsePort(V1IngressServiceBackend service) {
        V1ServiceBackendPort servicePort = service.getPort();
        if (Objects.nonNull(servicePort)) {
            Integer portNumber = servicePort.getNumber();
            if (Objects.nonNull(portNumber) && portNumber > 0) {
                return String.valueOf(portNumber);
            }
            String servicePortName = servicePort.getName();
            if (Objects.nonNull(servicePortName) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{servicePortName.trim()})) {
                return servicePortName.trim();
            }
        }
        return null;
    }

    private List<IngressConfiguration> parseIngressRule(V1IngressRule ingressRule, String namespace, Map<String, String> annotations, Map<String, String> labels) {
        List paths;
        ConditionData hostCondition;
        ArrayList<IngressConfiguration> res = new ArrayList<IngressConfiguration>();
        ConditionData conditionData = hostCondition = Objects.nonNull(ingressRule.getHost()) ? this.createHostCondition(ingressRule.getHost()) : null;
        if (Objects.nonNull(ingressRule.getHttp()) && Objects.nonNull(paths = ingressRule.getHttp().getPaths())) {
            for (V1HTTPIngressPath path : paths) {
                String pathPath = path.getPath();
                if (Objects.isNull(pathPath)) continue;
                OperatorEnum operator = this.getOperator(path.getPathType());
                ConditionData pathCondition = this.createPathCondition(pathPath, operator);
                ArrayList<ConditionData> conditionList = new ArrayList<ConditionData>(2);
                if (Objects.nonNull(hostCondition)) {
                    conditionList.add(hostCondition);
                }
                conditionList.add(pathCondition);
                List<GrpcUpstream> grpcUpstreamList = this.parseUpstream(path.getBackend(), namespace);
                SelectorData selectorData = this.createSelectorData(pathPath, conditionList, grpcUpstreamList);
                ArrayList<RuleData> ruleDataList = new ArrayList<RuleData>();
                ArrayList<MetaData> metaDataList = new ArrayList<MetaData>();
                for (String label : labels.keySet()) {
                    Map metadataAnnotations = ((V1Service)this.serviceLister.namespace(namespace).get(labels.get(label))).getMetadata().getAnnotations();
                    List<ConditionData> ruleConditionList = this.getRuleConditionList(metadataAnnotations);
                    RuleData ruleData = this.createRuleData(metadataAnnotations, ruleConditionList, annotations);
                    MetaData metaData = this.parseMetaData(metadataAnnotations);
                    ruleDataList.add(ruleData);
                    metaDataList.add(metaData);
                }
                res.add(new IngressConfiguration(selectorData, ruleDataList, metaDataList));
            }
        }
        return res;
    }

    private List<ConditionData> getRuleConditionList(Map<String, String> annotations) {
        ArrayList<ConditionData> ruleConditionList = new ArrayList<ConditionData>();
        ConditionData ruleCondition = new ConditionData();
        ruleCondition.setOperator(OperatorEnum.EQ.getAlias());
        ruleCondition.setParamType(ParamTypeEnum.URI.getName());
        ruleCondition.setParamValue(annotations.get("shenyu.apache.org/plugin-grpc-path"));
        ruleConditionList.add(ruleCondition);
        return ruleConditionList;
    }

    private ConditionData createHostCondition(String host) {
        ConditionData hostCondition = new ConditionData();
        hostCondition.setParamType(ParamTypeEnum.DOMAIN.getName());
        hostCondition.setOperator(OperatorEnum.EQ.getAlias());
        hostCondition.setParamValue(host);
        return hostCondition;
    }

    private OperatorEnum getOperator(String pathType) {
        if ("ImplementationSpecific".equals(pathType)) {
            return OperatorEnum.MATCH;
        }
        if ("Prefix".equals(pathType)) {
            return OperatorEnum.STARTS_WITH;
        }
        if ("Exact".equals(pathType)) {
            return OperatorEnum.EQ;
        }
        LOG.info("Invalid path type, set it with match operator");
        return OperatorEnum.MATCH;
    }

    private ConditionData createPathCondition(String path, OperatorEnum operator) {
        ConditionData pathCondition = new ConditionData();
        pathCondition.setOperator(operator.getAlias());
        pathCondition.setParamType(ParamTypeEnum.URI.getName());
        pathCondition.setParamValue(path);
        return pathCondition;
    }

    private SelectorData createSelectorData(String path, List<ConditionData> conditionList, List<GrpcUpstream> grpcUpstreamList) {
        return SelectorData.builder().pluginId(String.valueOf(PluginEnum.GRPC.getCode())).pluginName(PluginEnum.GRPC.getName()).name(path).matchMode(Integer.valueOf(MatchModeEnum.AND.getCode())).type(Integer.valueOf(SelectorTypeEnum.CUSTOM_FLOW.getCode())).handle(GsonUtils.getInstance().toJson(grpcUpstreamList)).enabled(Boolean.valueOf(true)).logged(Boolean.valueOf(false)).continued(Boolean.valueOf(true)).conditionList(conditionList).build();
    }

    private RuleData createRuleData(Map<String, String> metadataAnnotations, List<ConditionData> ruleConditionList, Map<String, String> annotations) {
        GrpcRuleHandle grpcRuleHandle = new GrpcRuleHandle();
        if (Objects.nonNull(annotations)) {
            grpcRuleHandle.setLoadBalance(annotations.getOrDefault("shenyu.apache.org/loadbalancer", "random"));
        }
        return RuleData.builder().name(metadataAnnotations.get("shenyu.apache.org/plugin-grpc-path")).pluginName(PluginEnum.GRPC.getName()).matchMode(Integer.valueOf(MatchModeEnum.AND.getCode())).handle(GsonUtils.getInstance().toJson((Object)grpcRuleHandle)).conditionDataList(ruleConditionList).loged(Boolean.valueOf(true)).enabled(Boolean.valueOf(true)).build();
    }

    private MetaData parseMetaData(Map<String, String> annotations) {
        return MetaData.builder().appName(annotations.get("shenyu.apache.org/plugin-grpc-app-name")).path(annotations.get("shenyu.apache.org/plugin-grpc-path")).contextPath(annotations.get("shenyu.apache.org/plugin-context-path-path")).rpcType(annotations.get("shenyu.apache.org/plugin-grpc-rpc-type")).rpcExt(annotations.get("shenyu.apache.org/plugin-grpc-rpc-expand")).serviceName(annotations.get("shenyu.apache.org/plugin-grpc-service-name")).methodName(annotations.get("shenyu.apache.org/plugin-grpc-method-name")).parameterTypes(annotations.get("shenyu.apache.org/plugin-grpc-params-type")).enabled(Boolean.valueOf(true)).build();
    }

    private IngressConfiguration getRpcRouteConfig(List<GrpcUpstream> grpcUpStream, Map<String, String> annotations) {
        ConditionData conditionData = new ConditionData();
        conditionData.setParamName("grpc");
        conditionData.setParamType(ParamTypeEnum.URI.getName());
        conditionData.setOperator(OperatorEnum.PATH_PATTERN.getAlias());
        conditionData.setParamValue("/**");
        SelectorData selectorData = SelectorData.builder().name("grpc-selector").sort(Integer.valueOf(Integer.MAX_VALUE)).conditionList(Collections.singletonList(conditionData)).handle(GsonUtils.getInstance().toJson(grpcUpStream)).enabled(Boolean.valueOf(true)).id("1").pluginName(PluginEnum.GRPC.getName()).pluginId(String.valueOf(PluginEnum.GRPC.getCode())).logged(Boolean.valueOf(false)).continued(Boolean.valueOf(true)).matchMode(Integer.valueOf(MatchModeEnum.AND.getCode())).type(Integer.valueOf(SelectorTypeEnum.FULL_FLOW.getCode())).build();
        GrpcRuleHandle grpcRuleHandle = new GrpcRuleHandle();
        if (Objects.nonNull(annotations)) {
            grpcRuleHandle.setLoadBalance(annotations.getOrDefault("shenyu.apache.org/loadbalancer", LoadBalanceEnum.RANDOM.getName()));
        }
        RuleData ruleData = RuleData.builder().selectorId("1").pluginName(PluginEnum.GRPC.getName()).name("grpc-rule").handle(GsonUtils.getInstance().toJson((Object)grpcRuleHandle)).matchMode(Integer.valueOf(MatchModeEnum.AND.getCode())).conditionDataList(Collections.singletonList(conditionData)).loged(Boolean.valueOf(false)).enabled(Boolean.valueOf(true)).sort(Integer.valueOf(Integer.MAX_VALUE)).build();
        MetaData metaData = new MetaData();
        if (Objects.nonNull(annotations)) {
            metaData.setAppName(annotations.getOrDefault("shenyu.apache.org/plugin-grpc-app-name", "grpc"));
            metaData.setMethodName(annotations.getOrDefault("shenyu.apache.org/plugin-grpc-method-name", "hello"));
            metaData.setPath(annotations.getOrDefault("shenyu.apache.org/plugin-grpc-path", "/grpc/helloService/hello"));
            metaData.setRpcType(annotations.getOrDefault("shenyu.apache.org/plugin-grpc-rpc-type", RpcTypeEnum.GRPC.getName()));
            metaData.setServiceName(annotations.getOrDefault("shenyu.apache.org/plugin-grpc-service-name", "hello.HelloService"));
            metaData.setContextPath(annotations.getOrDefault("shenyu.apache.org/plugin-grpc-context-path", "/grpc"));
            metaData.setRpcExt(annotations.getOrDefault("shenyu.apache.org/plugin-grpc-rpc-expand", "{\"timeout\":5000,\"methodType\":\"UNARY\"}"));
            metaData.setServiceName(annotations.getOrDefault("shenyu.apache.org/plugin-grpc-service-name", "hello.HelloService"));
            metaData.setParameterTypes(annotations.getOrDefault("shenyu.apache.org/plugin-grpc-parameter-type", "hello.HelloRequest,io.grpc.stub.StreamObserver"));
            metaData.setEnabled(Boolean.valueOf(Boolean.parseBoolean(annotations.getOrDefault("shenyu.apache.org/plugin-grpc-enabled", "true"))));
        }
        return new IngressConfiguration(selectorData, Arrays.asList(ruleData), Arrays.asList(metaData));
    }
}

