/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.k8s.cache;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;

public final class ServiceIngressCache {
    private static final ServiceIngressCache INSTANCE = new ServiceIngressCache();
    private static final Map<String, List<Pair<String, String>>> INGRESS_MAP = Maps.newConcurrentMap();

    private ServiceIngressCache() {
    }

    public static ServiceIngressCache getInstance() {
        return INSTANCE;
    }

    public List<Pair<String, String>> getIngressName(String namespace, String serviceName) {
        return INGRESS_MAP.get(this.getKey(namespace, serviceName));
    }

    public void putIngressName(String namespace, String serviceName, String ingressNamespace, String ingressName) {
        List list = INGRESS_MAP.computeIfAbsent(this.getKey(namespace, serviceName), k -> new ArrayList());
        list.add(Pair.of((Object)ingressNamespace, (Object)ingressName));
    }

    public List<Pair<String, String>> removeAllIngressName(String namespace, String serviceName) {
        return INGRESS_MAP.remove(this.getKey(namespace, serviceName));
    }

    public void removeSpecifiedIngressName(String namespace, String serviceName, String ingressNamespace, String ingressName) {
        List<Pair<String, String>> list = INGRESS_MAP.get(this.getKey(namespace, serviceName));
        if (Objects.nonNull(list)) {
            list.removeIf(item -> ((String)item.getLeft()).equals(ingressNamespace) && ((String)item.getRight()).equals(ingressName));
        }
    }

    private String getKey(String namespace, String name) {
        return String.format("%s-%s", namespace, name);
    }
}

