/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.tars;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.client.core.client.AbstractContextRefreshedEventListener;
import org.apache.shenyu.client.core.disruptor.ShenyuClientRegisterEventPublisher;
import org.apache.shenyu.client.core.exception.ShenyuClientIllegalArgumentException;
import org.apache.shenyu.client.tars.common.annotation.ShenyuTarsClient;
import org.apache.shenyu.client.tars.common.annotation.ShenyuTarsService;
import org.apache.shenyu.client.tars.common.dto.TarsRpcExt;
import org.apache.shenyu.common.enums.ApiHttpMethodEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.config.ShenyuClientConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.enums.EventType;
import org.apache.shenyu.register.common.type.DataTypeParent;
import org.javatuples.Sextet;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.core.StandardReflectionParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;

public class TarsServiceBeanEventListener
extends AbstractContextRefreshedEventListener<Object, ShenyuTarsClient> {
    private final StandardReflectionParameterNameDiscoverer localVariableTableParameterNameDiscoverer = new StandardReflectionParameterNameDiscoverer();
    private final ShenyuClientRegisterEventPublisher publisher = ShenyuClientRegisterEventPublisher.getInstance();
    private final String contextPath;
    private final String ipAndPort;

    public TarsServiceBeanEventListener(ShenyuClientConfig clientConfig, ShenyuClientRegisterRepository shenyuClientRegisterRepository) {
        super(clientConfig, shenyuClientRegisterRepository);
        Properties props = ((ShenyuClientConfig.ClientPropertiesConfig)clientConfig.getClient().get(this.getClientName())).getProps();
        String contextPath = props.getProperty("contextPath");
        String port = props.getProperty("port");
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{contextPath, this.getHost(), port})) {
            throw new ShenyuClientIllegalArgumentException("tars client must config the contextPath, ipAndPort");
        }
        this.contextPath = contextPath;
        this.ipAndPort = this.getHost() + ":" + port;
        this.publisher.start(shenyuClientRegisterRepository);
    }

    protected Sextet<String[], String, String, ApiHttpMethodEnum[], RpcTypeEnum, String> buildApiDocSextet(Method method, Annotation annotation, Map<String, Object> beans) {
        ShenyuTarsClient shenyuTarsClient = (ShenyuTarsClient)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ShenyuTarsClient.class);
        if (Objects.isNull(shenyuTarsClient)) {
            return null;
        }
        String produce = "*/*";
        String consume = "*/*";
        String[] values = new String[]{shenyuTarsClient.value()};
        ApiHttpMethodEnum[] apiHttpMethodEnums = new ApiHttpMethodEnum[]{ApiHttpMethodEnum.NOT_HTTP};
        String version = "v0.01";
        return Sextet.with((Object)values, (Object)consume, (Object)produce, (Object)apiHttpMethodEnums, (Object)RpcTypeEnum.TARS, (Object)version);
    }

    protected Map<String, Object> getBeans(ApplicationContext context) {
        return context.getBeansWithAnnotation(ShenyuTarsService.class);
    }

    protected URIRegisterDTO buildURIRegisterDTO(ApplicationContext context, Map<String, Object> beans, String namespaceId) {
        return URIRegisterDTO.builder().contextPath(this.contextPath).appName(this.ipAndPort).rpcType(RpcTypeEnum.TARS.getName()).eventType(EventType.REGISTER).host(this.getHost()).port(Integer.valueOf(Integer.parseInt(this.getPort()))).namespaceId(namespaceId).build();
    }

    protected String getClientName() {
        return RpcTypeEnum.TARS.getName();
    }

    protected String buildApiSuperPath(Class<?> clazz, @Nullable ShenyuTarsClient shenyuTarsClient) {
        if (Objects.nonNull(shenyuTarsClient) && !StringUtils.isBlank((CharSequence)shenyuTarsClient.path())) {
            return shenyuTarsClient.path();
        }
        return "";
    }

    protected Class<ShenyuTarsClient> getAnnotationType() {
        return ShenyuTarsClient.class;
    }

    public void handle(String beanName, Object bean) {
        Class clazz = bean.getClass();
        if (AopUtils.isAopProxy((Object)bean)) {
            clazz = AopUtils.getTargetClass((Object)bean);
        }
        ShenyuTarsClient beanTarsClient = (ShenyuTarsClient)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)clazz, ShenyuTarsClient.class);
        String superPath = this.buildApiSuperPath(clazz, beanTarsClient);
        List namespaceIds = super.getNamespace();
        if (superPath.contains("*") && Objects.nonNull(beanTarsClient)) {
            Method[] declaredMethods = ReflectionUtils.getDeclaredMethods((Class)clazz);
            for (String namespaceId : namespaceIds) {
                for (Method declaredMethod : declaredMethods) {
                    this.publisher.publishEvent((DataTypeParent)this.buildMetaDataDTO(bean, beanTarsClient, this.buildApiPath(declaredMethod, superPath, beanTarsClient), clazz, declaredMethod, namespaceId));
                }
            }
            return;
        }
        Method[] methods = ReflectionUtils.getUniqueDeclaredMethods((Class)clazz);
        for (String namespaceId : namespaceIds) {
            for (Method method : methods) {
                ShenyuTarsClient shenyuTarsClient = (ShenyuTarsClient)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ShenyuTarsClient.class);
                if (!Objects.nonNull(shenyuTarsClient)) continue;
                this.publisher.publishEvent((DataTypeParent)this.buildMetaDataDTO(bean, shenyuTarsClient, this.buildApiPath(method, superPath, shenyuTarsClient), clazz, method, namespaceId));
            }
        }
    }

    public MetaDataRegisterDTO buildMetaDataDTO(Object bean, @NonNull ShenyuTarsClient shenyuTarsClient, String path, Class<?> clazz, Method method, String namespaceId) {
        String serviceName = clazz.getAnnotation(ShenyuTarsService.class).serviceName();
        String ipAndPort = this.ipAndPort;
        String desc = shenyuTarsClient.desc();
        String configRuleName = shenyuTarsClient.ruleName();
        String ruleName = "".equals(configRuleName) ? path : configRuleName;
        String methodName = method.getName();
        Class<?>[] parameterTypesClazz = method.getParameterTypes();
        String parameterTypes = Arrays.stream(parameterTypesClazz).map(Class::getName).collect(Collectors.joining(","));
        return MetaDataRegisterDTO.builder().appName(ipAndPort).serviceName(serviceName).methodName(methodName).contextPath(this.contextPath).path(path).host(super.getHost()).port(Integer.valueOf(Integer.parseInt(this.getPort()))).ruleName(ruleName).pathDesc(desc).parameterTypes(parameterTypes).rpcType(RpcTypeEnum.TARS.getName()).rpcExt(this.buildRpcExtJson(method)).enabled(shenyuTarsClient.enabled()).namespaceId(namespaceId).build();
    }

    protected String buildApiPath(Method method, String superPath, ShenyuTarsClient shenyuTarsClient) {
        return superPath.contains("*") ? this.pathJoin(new String[]{this.contextPath, superPath.replace("*", ""), method.getName()}) : this.pathJoin(new String[]{this.contextPath, superPath, shenyuTarsClient.path()});
    }

    private TarsRpcExt.RpcExt buildRpcExt(Method method) {
        String[] paramNames = this.localVariableTableParameterNameDiscoverer.getParameterNames(method);
        ArrayList<Pair<String, String>> params = new ArrayList<Pair<String, String>>();
        if (Objects.nonNull(paramNames) && paramNames.length > 0) {
            Class<?>[] paramTypes = method.getParameterTypes();
            for (int i = 0; i < paramNames.length; ++i) {
                params.add((Pair<String, String>)Pair.of((Object)paramTypes[i].getName(), (Object)paramNames[i]));
            }
        }
        return new TarsRpcExt.RpcExt(method.getName(), params, method.getReturnType().getName());
    }

    private String buildRpcExtJson(Method method) {
        ArrayList<TarsRpcExt.RpcExt> list = new ArrayList<TarsRpcExt.RpcExt>();
        list.add(this.buildRpcExt(method));
        TarsRpcExt buildList = new TarsRpcExt(list);
        return GsonUtils.getInstance().toJson((Object)buildList);
    }
}

