/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.sofa;

import com.alipay.sofa.runtime.service.component.Service;
import com.alipay.sofa.runtime.spring.factory.ServiceFactoryBean;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.client.core.client.AbstractContextRefreshedEventListener;
import org.apache.shenyu.client.sofa.common.annotation.ShenyuSofaClient;
import org.apache.shenyu.client.sofa.common.dto.SofaRpcExt;
import org.apache.shenyu.common.enums.ApiHttpMethodEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.config.ShenyuClientConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.enums.EventType;
import org.apache.shenyu.register.common.type.DataTypeParent;
import org.javatuples.Sextet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.NonNull;
import org.springframework.util.ReflectionUtils;

public class SofaServiceEventListener
extends AbstractContextRefreshedEventListener<ServiceFactoryBean, ShenyuSofaClient> {
    private static final Logger LOG = LoggerFactory.getLogger(SofaServiceEventListener.class);

    public SofaServiceEventListener(ShenyuClientConfig clientConfig, ShenyuClientRegisterRepository shenyuClientRegisterRepository) {
        super(clientConfig, shenyuClientRegisterRepository);
    }

    protected Map<String, ServiceFactoryBean> getBeans(ApplicationContext context) {
        return context.getBeansOfType(ServiceFactoryBean.class);
    }

    protected URIRegisterDTO buildURIRegisterDTO(ApplicationContext context, Map<String, ServiceFactoryBean> beans, String namespaceId) {
        return URIRegisterDTO.builder().contextPath(this.getContextPath()).appName(this.getAppName()).rpcType(RpcTypeEnum.SOFA.getName()).eventType(EventType.REGISTER).host(super.getHost()).port(Integer.valueOf(Integer.parseInt(this.getPort()))).namespaceId(namespaceId).build();
    }

    protected String getClientName() {
        return RpcTypeEnum.SOFA.getName();
    }

    protected String buildApiSuperPath(Class<?> clazz, ShenyuSofaClient beanShenyuClient) {
        if (Objects.nonNull(beanShenyuClient) && !StringUtils.isBlank((CharSequence)beanShenyuClient.path())) {
            return beanShenyuClient.path();
        }
        return "";
    }

    protected Class<ShenyuSofaClient> getAnnotationType() {
        return ShenyuSofaClient.class;
    }

    protected String buildApiPath(Method method, String superPath, @NonNull ShenyuSofaClient shenyuSofaClient) {
        String contextPath = this.getContextPath();
        return superPath.contains("*") ? this.pathJoin(new String[]{contextPath, superPath.replace("*", ""), method.getName()}) : this.pathJoin(new String[]{contextPath, superPath, shenyuSofaClient.path()});
    }

    protected MetaDataRegisterDTO buildMetaDataDTO(ServiceFactoryBean serviceBean, @NonNull ShenyuSofaClient shenyuSofaClient, String superPath, Class<?> clazz, Method method, String namespaceId) {
        String appName = this.getAppName();
        String contextPath = this.getContextPath();
        String path = this.pathJoin(new String[]{contextPath, superPath, shenyuSofaClient.path()});
        String serviceName = serviceBean.getInterfaceClass().getName();
        String desc = shenyuSofaClient.desc();
        String configRuleName = shenyuSofaClient.ruleName();
        String ruleName = StringUtils.isEmpty((CharSequence)configRuleName) ? path : configRuleName;
        String methodName = method.getName();
        String parameterTypes = Arrays.stream(method.getParameters()).map(parameter -> {
            StringBuilder result = new StringBuilder(parameter.getType().getName());
            Type type = parameter.getParameterizedType();
            if (type instanceof ParameterizedType) {
                Type[] actualTypeArguments;
                for (Type actualTypeArgument : actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments()) {
                    result.append("#").append(actualTypeArgument.getTypeName());
                }
            }
            return result.toString();
        }).collect(Collectors.joining(","));
        return MetaDataRegisterDTO.builder().appName(appName).serviceName(serviceName).methodName(methodName).contextPath(contextPath).host(super.getHost()).port(Integer.valueOf(Integer.parseInt(this.getPort()))).path(path).ruleName(ruleName).pathDesc(desc).parameterTypes(parameterTypes).rpcType(RpcTypeEnum.SOFA.getName()).rpcExt(this.buildRpcExt(shenyuSofaClient)).enabled(shenyuSofaClient.enabled()).namespaceId(namespaceId).build();
    }

    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        Map serviceBean = contextRefreshedEvent.getApplicationContext().getBeansOfType(ServiceFactoryBean.class);
        for (Map.Entry entry : serviceBean.entrySet()) {
            this.handler((ServiceFactoryBean)entry.getValue());
        }
    }

    protected Sextet<String[], String, String, ApiHttpMethodEnum[], RpcTypeEnum, String> buildApiDocSextet(Method method, Annotation annotation, Map<String, ServiceFactoryBean> beans) {
        ShenyuSofaClient shenyuSofaClient = (ShenyuSofaClient)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ShenyuSofaClient.class);
        if (Objects.isNull(shenyuSofaClient)) {
            return null;
        }
        String produce = "*/*";
        String consume = "*/*";
        String[] values = new String[]{shenyuSofaClient.value()};
        ApiHttpMethodEnum[] apiHttpMethodEnums = new ApiHttpMethodEnum[]{ApiHttpMethodEnum.NOT_HTTP};
        String version = "v0.01";
        return Sextet.with((Object)values, (Object)consume, (Object)produce, (Object)apiHttpMethodEnums, (Object)RpcTypeEnum.SOFA, (Object)version);
    }

    private void handler(ServiceFactoryBean serviceBean) {
        Class clazz;
        Object targetProxy;
        try {
            targetProxy = ((Service)Objects.requireNonNull(serviceBean.getObject())).getTarget();
            clazz = targetProxy.getClass();
        }
        catch (Exception e) {
            LOG.error("failed to get sofa target class", (Throwable)e);
            return;
        }
        if (AopUtils.isAopProxy((Object)targetProxy)) {
            clazz = AopUtils.getTargetClass((Object)targetProxy);
        }
        ShenyuSofaClient beanSofaClient = (ShenyuSofaClient)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)clazz, ShenyuSofaClient.class);
        String superPath = this.buildApiSuperPath(clazz, beanSofaClient);
        List namespaceIds = super.getNamespace();
        if (superPath.contains("*") && Objects.nonNull(beanSofaClient)) {
            Method[] declaredMethods = ReflectionUtils.getDeclaredMethods((Class)clazz);
            for (String namespaceId : namespaceIds) {
                for (Method declaredMethod : declaredMethods) {
                    this.getPublisher().publishEvent((DataTypeParent)this.buildMetaDataDTO(serviceBean, beanSofaClient, superPath, clazz, declaredMethod, namespaceId));
                }
            }
            return;
        }
        Method[] methods = ReflectionUtils.getUniqueDeclaredMethods((Class)clazz);
        for (String namespaceId : namespaceIds) {
            for (Method method : methods) {
                ShenyuSofaClient methodSofaClient = (ShenyuSofaClient)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ShenyuSofaClient.class);
                if (!Objects.nonNull(methodSofaClient)) continue;
                this.getPublisher().publishEvent((DataTypeParent)this.buildMetaDataDTO(serviceBean, methodSofaClient, superPath, clazz, method, namespaceId));
            }
        }
    }

    private String buildRpcExt(ShenyuSofaClient shenyuSofaClient) {
        SofaRpcExt build = SofaRpcExt.builder().loadbalance(shenyuSofaClient.loadBalance()).retries(shenyuSofaClient.retries()).timeout(shenyuSofaClient.timeout()).build();
        return GsonUtils.getInstance().toJson((Object)build);
    }
}

