/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.motan;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.weibo.api.motan.config.springsupport.BasicServiceConfigBean;
import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.shenyu.client.core.disruptor.ShenyuClientRegisterEventPublisher;
import org.apache.shenyu.client.core.exception.ShenyuClientIllegalArgumentException;
import org.apache.shenyu.client.motan.common.annotation.ShenyuMotanClient;
import org.apache.shenyu.client.motan.common.dto.MotanRpcExt;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.IpUtils;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.config.PropertiesConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.util.ReflectionUtils;

public class MotanServiceBeanPostProcessor
implements BeanPostProcessor,
ApplicationContextAware {
    private static final String BASE_SERVICE_CONFIG = "baseServiceConfig";
    private final LocalVariableTableParameterNameDiscoverer localVariableTableParameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private ShenyuClientRegisterEventPublisher publisher = ShenyuClientRegisterEventPublisher.getInstance();
    private ApplicationContext applicationContext;
    private final ExecutorService executorService;
    private final String contextPath;
    private final String appName;
    private final String host;
    private final String port;
    private String group;

    public MotanServiceBeanPostProcessor(PropertiesConfig clientConfig, ShenyuClientRegisterRepository shenyuClientRegisterRepository) {
        Properties props = clientConfig.getProps();
        String contextPath = props.getProperty("contextPath");
        String appName = props.getProperty("appName");
        if (StringUtils.isEmpty((CharSequence)contextPath)) {
            throw new ShenyuClientIllegalArgumentException("motan client must config the contextPath");
        }
        this.contextPath = contextPath;
        this.appName = appName;
        this.host = props.getProperty("host");
        this.port = props.getProperty("port");
        this.executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("shenyu-motan-client-thread-pool-%d").build());
        this.publisher.start(shenyuClientRegisterRepository);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        MotanService service;
        Class clazz = bean.getClass();
        if (AopUtils.isAopProxy((Object)bean)) {
            clazz = AopUtils.getTargetClass((Object)bean);
        }
        if ((service = clazz.getAnnotation(MotanService.class)) != null) {
            this.executorService.execute(() -> this.handler(bean));
        }
        return bean;
    }

    private void handler(Object bean) {
        if (this.group == null) {
            this.group = ((BasicServiceConfigBean)this.applicationContext.getBean(BASE_SERVICE_CONFIG)).getGroup();
        }
        Class clazz = bean.getClass();
        if (AopUtils.isAopProxy((Object)bean)) {
            clazz = AopUtils.getTargetClass((Object)bean);
        }
        Method[] methods = ReflectionUtils.getUniqueDeclaredMethods(clazz);
        MotanService service = clazz.getAnnotation(MotanService.class);
        for (Method method : methods) {
            ShenyuMotanClient shenyuMotanClient = method.getAnnotation(ShenyuMotanClient.class);
            if (!Objects.nonNull(shenyuMotanClient)) continue;
            this.publisher.publishEvent((Object)this.buildMetaDataDTO(clazz, service, shenyuMotanClient, method, this.buildRpcExt(methods)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MetaDataRegisterDTO buildMetaDataDTO(Class<?> clazz, MotanService service, ShenyuMotanClient shenyuMotanClient, Method method, String rpcExt) {
        String serviceName;
        String appName = this.appName;
        String path = this.contextPath + shenyuMotanClient.path();
        String desc = shenyuMotanClient.desc();
        String host = IpUtils.isCompleteHost((String)this.host) ? this.host : IpUtils.getHost((String)this.host);
        int port = StringUtils.isBlank((CharSequence)this.port) ? -1 : Integer.parseInt(this.port);
        String configRuleName = shenyuMotanClient.ruleName();
        String ruleName = "".equals(configRuleName) ? path : configRuleName;
        String methodName = method.getName();
        Class<?>[] parameterTypesClazz = method.getParameterTypes();
        String parameterTypes = Arrays.stream(parameterTypesClazz).map(Class::getName).collect(Collectors.joining(","));
        if (Void.TYPE.equals(service.interfaceClass())) {
            if (clazz.getInterfaces().length <= 0) throw new ShenyuClientIllegalArgumentException("Failed to export remote service class " + clazz.getName() + ", cause: The @Service undefined interfaceClass or interfaceName, and the service class unimplemented any interfaces.");
            serviceName = clazz.getInterfaces()[0].getName();
            return MetaDataRegisterDTO.builder().appName(appName).serviceName(serviceName).methodName(methodName).contextPath(this.contextPath).path(path).port(Integer.valueOf(port)).host(host).ruleName(ruleName).pathDesc(desc).parameterTypes(parameterTypes).rpcType(RpcTypeEnum.MOTAN.getName()).rpcExt(rpcExt).enabled(shenyuMotanClient.enabled()).build();
        } else {
            serviceName = service.interfaceClass().getName();
        }
        return MetaDataRegisterDTO.builder().appName(appName).serviceName(serviceName).methodName(methodName).contextPath(this.contextPath).path(path).port(Integer.valueOf(port)).host(host).ruleName(ruleName).pathDesc(desc).parameterTypes(parameterTypes).rpcType(RpcTypeEnum.MOTAN.getName()).rpcExt(rpcExt).enabled(shenyuMotanClient.enabled()).build();
    }

    private MotanRpcExt.RpcExt buildRpcExt(Method method) {
        String[] paramNames = this.localVariableTableParameterNameDiscoverer.getParameterNames(method);
        ArrayList<Pair<String, String>> params = new ArrayList<Pair<String, String>>();
        if (paramNames != null && paramNames.length > 0) {
            Class<?>[] paramTypes = method.getParameterTypes();
            for (int i = 0; i < paramNames.length; ++i) {
                params.add((Pair<String, String>)Pair.of((Object)paramTypes[i].getName(), (Object)paramNames[i]));
            }
        }
        return new MotanRpcExt.RpcExt(method.getName(), params);
    }

    private String buildRpcExt(Method[] methods) {
        ArrayList<MotanRpcExt.RpcExt> list = new ArrayList<MotanRpcExt.RpcExt>();
        for (Method method : methods) {
            ShenyuMotanClient shenyuMotanClient = method.getAnnotation(ShenyuMotanClient.class);
            if (!Objects.nonNull(shenyuMotanClient)) continue;
            list.add(this.buildRpcExt(method));
        }
        MotanRpcExt buildList = new MotanRpcExt(list, this.group);
        return GsonUtils.getInstance().toJson((Object)buildList);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

