/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.client.apache.dubbo;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.MethodConfig;
import org.apache.dubbo.config.spring.ServiceBean;
import org.apache.shenyu.client.core.client.AbstractContextRefreshedEventListener;
import org.apache.shenyu.client.dubbo.common.annotation.ShenyuDubboClient;
import org.apache.shenyu.client.dubbo.common.dto.DubboRpcExt;
import org.apache.shenyu.client.dubbo.common.dto.DubboRpcMethodExt;
import org.apache.shenyu.common.enums.ApiHttpMethodEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.config.ShenyuClientConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.enums.EventType;
import org.apache.shenyu.register.common.type.DataTypeParent;
import org.javatuples.Sextet;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;

public class ApacheDubboServiceBeanListener
extends AbstractContextRefreshedEventListener<ServiceBean, ShenyuDubboClient> {
    public ApacheDubboServiceBeanListener(ShenyuClientConfig clientConfig, ShenyuClientRegisterRepository shenyuClientRegisterRepository) {
        super(clientConfig, shenyuClientRegisterRepository);
    }

    protected Sextet<String[], String, String, ApiHttpMethodEnum[], RpcTypeEnum, String> buildApiDocSextet(Method method, Annotation annotation, Map<String, ServiceBean> beans) {
        Class<?>[] interfaces;
        ShenyuDubboClient shenyuDubboClient = (ShenyuDubboClient)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ShenyuDubboClient.class);
        if (Objects.isNull(shenyuDubboClient)) {
            return null;
        }
        String produce = "*/*";
        String consume = "*/*";
        String[] values = new String[]{shenyuDubboClient.value()};
        ApiHttpMethodEnum[] apiHttpMethodEnums = new ApiHttpMethodEnum[]{ApiHttpMethodEnum.NOT_HTTP};
        String defaultVersion = "v0.01";
        Class<?> methodClass = method.getDeclaringClass();
        for (Class<?> anInterface : interfaces = methodClass.getInterfaces()) {
            if (!beans.containsKey(anInterface.getName())) continue;
            ServiceBean serviceBean = beans.get(anInterface.getName());
            defaultVersion = Optional.ofNullable(serviceBean.getVersion()).orElse(defaultVersion);
        }
        return Sextet.with((Object)values, (Object)consume, (Object)produce, (Object)apiHttpMethodEnums, (Object)RpcTypeEnum.DUBBO, (Object)defaultVersion);
    }

    protected Map<String, ServiceBean> getBeans(ApplicationContext context) {
        return context.getBeansOfType(ServiceBean.class);
    }

    protected Class<?> getCorrectedClass(ServiceBean bean) {
        Object refProxy = bean.getRef();
        Class clazz = refProxy.getClass();
        if (AopUtils.isAopProxy((Object)refProxy)) {
            clazz = AopUtils.getTargetClass((Object)refProxy);
        }
        return clazz;
    }

    protected URIRegisterDTO buildURIRegisterDTO(ApplicationContext context, Map<String, ServiceBean> beans, String namespaceId) {
        return beans.entrySet().stream().findFirst().map(entry -> {
            ServiceBean bean = (ServiceBean)entry.getValue();
            return URIRegisterDTO.builder().contextPath(this.getContextPath()).appName(this.buildAppName(bean)).rpcType(RpcTypeEnum.DUBBO.getName()).eventType(EventType.REGISTER).host(super.getHost()).port(Integer.valueOf(this.getPort())).namespaceId(namespaceId).build();
        }).orElse(null);
    }

    protected String getClientName() {
        return RpcTypeEnum.DUBBO.getName();
    }

    private String buildAppName(ServiceBean<?> serviceBean) {
        String appName = this.getAppName();
        return StringUtils.isBlank((CharSequence)appName) ? serviceBean.getApplication().getName() : appName;
    }

    protected Class<ShenyuDubboClient> getAnnotationType() {
        return ShenyuDubboClient.class;
    }

    protected String buildApiSuperPath(Class<?> clazz, @Nullable ShenyuDubboClient beanShenyuClient) {
        if (Objects.nonNull(beanShenyuClient) && !StringUtils.isBlank((CharSequence)beanShenyuClient.path())) {
            return beanShenyuClient.path();
        }
        return "";
    }

    protected void handleClass(Class<?> clazz, ServiceBean bean, @NonNull ShenyuDubboClient beanShenyuClient, String superPath) {
        List namespaceIds = super.getNamespace();
        Method[] methods = ReflectionUtils.getDeclaredMethods(clazz);
        for (String namespaceId : namespaceIds) {
            for (Method method : methods) {
                MetaDataRegisterDTO metaData = this.buildMetaDataDTO(bean, beanShenyuClient, this.buildApiPath(method, superPath, (ShenyuDubboClient)null), clazz, method, namespaceId);
                this.getPublisher().publishEvent((DataTypeParent)metaData);
                this.getMetaDataMap().put(method, metaData);
            }
        }
    }

    protected String buildApiPath(Method method, String superPath, @Nullable ShenyuDubboClient methodShenyuClient) {
        String contextPath = this.getContextPath();
        return superPath.contains("*") ? this.pathJoin(new String[]{contextPath, superPath.replace("*", ""), method.getName()}) : this.pathJoin(new String[]{contextPath, superPath, Objects.requireNonNull(methodShenyuClient).path()});
    }

    protected MetaDataRegisterDTO buildMetaDataDTO(ServiceBean bean, @NonNull ShenyuDubboClient shenyuClient, String path, Class<?> clazz, Method method, String namespaceId) {
        String appName = this.buildAppName(bean);
        String desc = shenyuClient.desc();
        String serviceName = bean.getInterface();
        String configRuleName = shenyuClient.ruleName();
        String ruleName = "".equals(configRuleName) ? path : configRuleName;
        String methodName = Optional.ofNullable(method).map(Method::getName).orElseThrow(() -> new ShenyuException("unexpected error"));
        Class<?>[] parameterTypesClazz = method.getParameterTypes();
        String parameterTypes = Arrays.stream(parameterTypesClazz).map(Class::getName).collect(Collectors.joining(","));
        return MetaDataRegisterDTO.builder().appName(appName).serviceName(serviceName).methodName(methodName).contextPath(this.getContextPath()).host(super.getHost()).port(Integer.valueOf(this.getPort())).path(path).ruleName(ruleName).pathDesc(desc).parameterTypes(parameterTypes).rpcExt(this.buildRpcExt(bean, methodName)).rpcType(RpcTypeEnum.DUBBO.getName()).enabled(shenyuClient.enabled()).namespaceId(namespaceId).build();
    }

    public String getPort() {
        String port = super.getPort();
        return this.getContext().getBeansOfType(ServiceBean.class).entrySet().stream().findFirst().map(entry -> {
            ServiceBean serviceBean = (ServiceBean)entry.getValue();
            return StringUtils.isBlank((CharSequence)port) || "-1".equals(port) ? String.valueOf(serviceBean.getProtocol().getPort()) : port;
        }).orElse(port);
    }

    private String buildRpcExt(ServiceBean<?> serviceBean, String methodName) {
        DubboRpcExt build = DubboRpcExt.builder().protocol(StringUtils.isNotEmpty((CharSequence)serviceBean.getProtocol().getName()) ? serviceBean.getProtocol().getName() : "").group(StringUtils.isNotEmpty((CharSequence)serviceBean.getGroup()) ? serviceBean.getGroup() : "").version(StringUtils.isNotEmpty((CharSequence)serviceBean.getVersion()) ? serviceBean.getVersion() : "").loadbalance(StringUtils.isNotEmpty((CharSequence)serviceBean.getLoadbalance()) ? serviceBean.getLoadbalance() : "random").retries(Optional.ofNullable(serviceBean.getRetries()).orElse(2)).timeout(Optional.ofNullable(serviceBean.getTimeout()).orElse(3000)).sent(Optional.ofNullable(serviceBean.getSent()).orElse(Boolean.FALSE)).cluster(StringUtils.isNotEmpty((CharSequence)serviceBean.getCluster()) ? serviceBean.getCluster() : "failover").url("").serialization(serviceBean.getSerialization()).build();
        if (Objects.nonNull(serviceBean.getMethods())) {
            build.setMethods(new ArrayList());
            for (MethodConfig methodConfig : serviceBean.getMethods()) {
                DubboRpcMethodExt methodExt = new DubboRpcMethodExt();
                methodExt.setName(methodConfig.getName());
                methodExt.setLoadbalance(methodConfig.getLoadbalance());
                methodExt.setRetries(methodConfig.getRetries());
                methodExt.setTimeout(methodConfig.getTimeout());
                methodExt.setSent(methodConfig.getSent());
                build.getMethods().add(methodExt);
            }
        }
        return GsonUtils.getInstance().toJson((Object)build);
    }
}

