/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okhttp3.Cookie;
import okhttp3.CookieJar;
import okhttp3.FormBody;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.HttpMethod;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.shenyu.common.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HttpUtils.class);
    private static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private Map<String, List<Cookie>> cookieStore = new HashMap<String, List<Cookie>>();
    private OkHttpClient httpClient;

    public HttpUtils() {
        this(new HttpToolConfig());
    }

    public HttpUtils(HttpToolConfig httpToolConfig) {
        this.initHttpClient(httpToolConfig);
    }

    public static Request.Builder buildRequestBuilder(String url, Map<String, ?> form, HTTPMethod method) {
        switch (method) {
            case GET: {
                return new Request.Builder().url(HttpUtils.buildHttpUrl(url, form)).get();
            }
            case HEAD: {
                return new Request.Builder().url(HttpUtils.buildHttpUrl(url, form)).head();
            }
            case PUT: {
                return new Request.Builder().url(HttpUtils.buildHttpUrl(url)).put((RequestBody)HttpUtils.buildFormBody(form));
            }
            case DELETE: {
                return new Request.Builder().url(HttpUtils.buildHttpUrl(url)).delete((RequestBody)HttpUtils.buildFormBody(form));
            }
        }
        return new Request.Builder().url(HttpUtils.buildHttpUrl(url)).post((RequestBody)HttpUtils.buildFormBody(form));
    }

    public static HttpUrl buildHttpUrl(String url) {
        return HttpUtils.buildHttpUrl(url, null);
    }

    public static HttpUrl buildHttpUrl(String url, Map<String, ?> form) {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)url).newBuilder();
        if (Objects.nonNull(form) && !form.isEmpty()) {
            for (Map.Entry<String, ?> entry : form.entrySet()) {
                urlBuilder.addQueryParameter(entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        return urlBuilder.build();
    }

    public static FormBody buildFormBody(Map<String, ?> form) {
        FormBody.Builder paramBuilder = new FormBody.Builder(StandardCharsets.UTF_8);
        for (Map.Entry<String, ?> entry : form.entrySet()) {
            paramBuilder.add(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return paramBuilder.build();
    }

    protected void initHttpClient(HttpToolConfig httpToolConfig) {
        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor(s -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug(s);
            }
        });
        httpLoggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        this.httpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)httpLoggingInterceptor).connectTimeout((long)httpToolConfig.connectTimeoutSeconds, TimeUnit.SECONDS).readTimeout((long)httpToolConfig.readTimeoutSeconds, TimeUnit.SECONDS).writeTimeout((long)httpToolConfig.writeTimeoutSeconds, TimeUnit.SECONDS).cookieJar(new CookieJar(){

            public void saveFromResponse(HttpUrl httpUrl, List<Cookie> list) {
                HttpUtils.this.cookieStore.put(httpUrl.host(), list);
            }

            public List<Cookie> loadForRequest(HttpUrl httpUrl) {
                ArrayList cookies = HttpUtils.this.cookieStore.get(httpUrl.host());
                return Objects.nonNull(cookies) ? cookies : new ArrayList();
            }
        }).build();
    }

    public String get(String url, Map<String, String> header) throws IOException {
        Request.Builder builder = new Request.Builder().url(url).get();
        this.addHeader(builder, header);
        return this.reqString(builder.build());
    }

    public String request(String url, Map<String, ?> form, Map<String, String> header, HTTPMethod method) throws IOException {
        Request.Builder requestBuilder = HttpUtils.buildRequestBuilder(url, form, method);
        this.addHeader(requestBuilder, header);
        return this.reqString(requestBuilder.build());
    }

    public Response requestJson(String url, String json, Map<String, String> header, HTTPMethod method) throws IOException {
        RequestBody body = RequestBody.create((MediaType)MEDIA_TYPE_JSON, (String)json);
        Request.Builder requestBuilder = new Request.Builder().url(url).method(method.value(), (RequestBody)(HttpMethod.requiresRequestBody((String)method.value()) ? body : null));
        this.addHeader(requestBuilder, header);
        Request request = requestBuilder.build();
        return this.httpClient.newCall(request).execute();
    }

    public String requestFileString(String url, Map<String, ?> form, Map<String, String> header, List<UploadFile> files) throws IOException {
        return this.requestFile(url, form, header, files).body().string();
    }

    public Response requestFile(String url, Map<String, ?> form, Map<String, String> header, List<UploadFile> files) throws IOException {
        MultipartBody.Builder bodyBuilder = new MultipartBody.Builder();
        bodyBuilder.setType(MultipartBody.FORM);
        for (UploadFile uploadFile : files) {
            bodyBuilder.addFormDataPart(uploadFile.getName(), uploadFile.getFileName(), RequestBody.create(null, (byte[])uploadFile.getFileData()));
        }
        for (Map.Entry entry : form.entrySet()) {
            bodyBuilder.addFormDataPart((String)entry.getKey(), String.valueOf(entry.getValue()));
        }
        MultipartBody requestBody = bodyBuilder.build();
        Request.Builder builder = new Request.Builder().url(HttpUtils.buildHttpUrl(url)).post((RequestBody)requestBody);
        this.addHeader(builder, header);
        Request request = builder.build();
        return this.httpClient.newCall(request).execute();
    }

    public Response requestCall(String url, Map<String, ?> form, Map<String, String> header, HTTPMethod method, List<UploadFile> files) throws IOException {
        if (Objects.nonNull(files) && !files.isEmpty()) {
            return this.requestFile(url, form, header, files);
        }
        if (this.isJsonRequest(header)) {
            return this.requestJson(url, JsonUtils.toJson(form), header, method);
        }
        return this.requestForResponse(url, form, header, method);
    }

    public Response requestForResponse(String url, Map<String, ?> form, Map<String, String> header, HTTPMethod method) throws IOException {
        Request.Builder requestBuilder = HttpUtils.buildRequestBuilder(url, form, method);
        this.addHeader(requestBuilder, header);
        Request request = requestBuilder.build();
        return this.httpClient.newCall(request).execute();
    }

    public InputStream downloadFile(String url, Map<String, ?> form, Map<String, String> header) throws IOException {
        Request.Builder requestBuilder = HttpUtils.buildRequestBuilder(url, form, HTTPMethod.GET);
        this.addHeader(requestBuilder, header);
        Request request = requestBuilder.build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (response.isSuccessful()) {
                ResponseBody body = response.body();
                InputStream inputStream = Objects.isNull(body) ? null : body.byteStream();
                return inputStream;
            }
            InputStream inputStream = null;
            return inputStream;
        }
    }

    public void setCookieStore(Map<String, List<Cookie>> cookieStore) {
        this.cookieStore = cookieStore;
    }

    public void setHttpClient(OkHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    private void addHeader(Request.Builder builder, Map<String, String> header) {
        if (Objects.nonNull(header)) {
            Set<Map.Entry<String, String>> entrySet = header.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                builder.addHeader(entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
    }

    private boolean isJsonRequest(Map<String, String> headers) {
        try {
            return Objects.compare(MEDIA_TYPE_JSON, MediaType.parse((String)headers.get("Content-Type")), Comparator.comparing(o -> String.format("%s/%s", o.type(), o.subtype()))) == 0;
        }
        catch (Exception e) {
            LOG.error("parse http client json request error: ", (Throwable)e);
            return false;
        }
    }

    private String reqString(Request request) throws IOException {
        try (Response response = this.httpClient.newCall(request).execute();){
            if (response.code() != 200) {
                throw new IOException(response.toString());
            }
            String string = response.body().string();
            return string;
        }
    }

    public static class HttpToolConfig {
        private int connectTimeoutSeconds = 10;
        private int readTimeoutSeconds = 10;
        private int writeTimeoutSeconds = 10;

        public int getConnectTimeoutSeconds() {
            return this.connectTimeoutSeconds;
        }

        public void setConnectTimeoutSeconds(int connectTimeoutSeconds) {
            this.connectTimeoutSeconds = connectTimeoutSeconds;
        }

        public int getReadTimeoutSeconds() {
            return this.readTimeoutSeconds;
        }

        public void setReadTimeoutSeconds(int readTimeoutSeconds) {
            this.readTimeoutSeconds = readTimeoutSeconds;
        }

        public int getWriteTimeoutSeconds() {
            return this.writeTimeoutSeconds;
        }

        public void setWriteTimeoutSeconds(int writeTimeoutSeconds) {
            this.writeTimeoutSeconds = writeTimeoutSeconds;
        }
    }

    public static enum HTTPMethod {
        GET,
        POST,
        PUT,
        HEAD,
        DELETE;


        public static HTTPMethod fromValue(String v) {
            return HTTPMethod.valueOf(v.toUpperCase());
        }

        public String value() {
            return this.name();
        }
    }

    public static class UploadFile
    implements Serializable {
        private static final long serialVersionUID = -1100614660944996398L;
        private String name;
        private String fileName;
        private byte[] fileData;
        private String md5;

        public UploadFile(String name, File file) throws IOException {
            this(name, file.getName(), FileUtils.toBytes(file));
        }

        public UploadFile(String name, String fileName, InputStream input) throws IOException {
            this(name, fileName, FileUtils.toBytes(input));
        }

        public UploadFile(String name, String fileName, byte[] fileData) {
            this.name = name;
            this.fileName = fileName;
            this.fileData = fileData;
            this.md5 = DigestUtils.md5Hex((byte[])fileData);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public byte[] getFileData() {
            return this.fileData;
        }

        public void setFileData(byte[] fileData) {
            this.fileData = fileData;
        }

        public String getMd5() {
            return this.md5;
        }

        public void setMd5(String md5) {
            this.md5 = md5;
        }
    }

    public static class FileUtils {
        private static final int DEFAULT_BUFFER_SIZE = 4096;
        private static final int EOF = -1;

        public static byte[] toBytes(InputStream input) throws IOException {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            int n = 0;
            byte[] buffer = new byte[4096];
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
            }
            return output.toByteArray();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static byte[] toBytes(File file) throws IOException {
            if (file.exists()) {
                if (file.isDirectory()) {
                    throw new IOException("File '" + file + "' exists but is a directory");
                }
                if (!file.canRead()) {
                    throw new IOException("File '" + file + "' cannot be read");
                }
            } else {
                throw new FileNotFoundException("File '" + file + "' does not exist");
            }
            InputStream input = null;
            try {
                input = Files.newInputStream(file.toPath(), new OpenOption[0]);
                byte[] byArray = FileUtils.toBytes(input);
                return byArray;
            }
            finally {
                try {
                    if (Objects.nonNull(input)) {
                        input.close();
                    }
                }
                catch (IOException ioe) {
                    LOG.error("toBytes error", (Throwable)ioe);
                }
            }
        }
    }
}

