/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.configs;

import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.AppAuthDTO;
import org.apache.shenyu.admin.model.result.ConfigImportResult;
import org.apache.shenyu.admin.model.vo.AppAuthVO;
import org.apache.shenyu.admin.service.AppAuthService;
import org.apache.shenyu.admin.service.configs.ConfigsExportImportEnum;
import org.apache.shenyu.admin.service.configs.ConfigsExportImportHandler;
import org.apache.shenyu.admin.service.configs.ConfigsImportContext;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.JsonUtils;
import org.springframework.stereotype.Component;

@Component
public class AuthConfigsExportImportHandler
implements ConfigsExportImportHandler {
    private final AppAuthService appAuthService;

    public AuthConfigsExportImportHandler(AppAuthService appAuthService) {
        this.appAuthService = appAuthService;
    }

    @Override
    public ConfigsExportImportEnum configsEnum() {
        return ConfigsExportImportEnum.Auth;
    }

    @Override
    public Optional<String> configsExport(String namespaceId) {
        List<AppAuthVO> authDataList = this.appAuthService.listAllDataByNamespace(namespaceId);
        if (CollectionUtils.isNotEmpty(authDataList)) {
            authDataList.forEach(appAuthVO -> appAuthVO.setNamespaceId(null));
            return Optional.of(JsonUtils.toJson(authDataList));
        }
        return Optional.empty();
    }

    @Override
    public void configsImport(String namespaceId, String data, ConfigsImportContext context) {
        List authDataList = GsonUtils.getInstance().fromList(data, AppAuthDTO.class);
        ConfigImportResult configImportResult = this.appAuthService.importData(namespaceId, authDataList);
        context.getResult().put("authImportSuccessCount", configImportResult.getSuccessCount());
        if (StringUtils.isNotEmpty((CharSequence)configImportResult.getFailMessage())) {
            context.getResult().put("authImportFailMessage", configImportResult.getFailMessage());
        }
    }
}

