/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.entity;

import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.RuleDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.common.dto.ConditionData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.utils.UUIDUtils;

public final class RuleDO
extends BaseDO {
    private static final long serialVersionUID = 8050178277098166539L;
    private String selectorId;
    private Integer matchMode;
    private String ruleName;
    private Boolean enabled;
    private Boolean loged;
    private Integer sortCode;
    private String handle;
    private Boolean matchRestful;
    private String namespaceId;

    public RuleDO() {
    }

    public RuleDO(String selectorId, Integer matchMode, String ruleName, Boolean enabled, Boolean loged, Integer sortCode, String handle, Boolean matchRestful, String namespaceId) {
        this.selectorId = selectorId;
        this.matchMode = matchMode;
        this.ruleName = ruleName;
        this.enabled = enabled;
        this.loged = loged;
        this.sortCode = sortCode;
        this.handle = handle;
        this.matchRestful = matchRestful;
        this.namespaceId = namespaceId;
    }

    public String getSelectorId() {
        return this.selectorId;
    }

    public void setSelectorId(String selectorId) {
        this.selectorId = selectorId;
    }

    public Integer getMatchMode() {
        return this.matchMode;
    }

    public void setMatchMode(Integer matchMode) {
        this.matchMode = matchMode;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getLoged() {
        return this.loged;
    }

    public void setLoged(Boolean loged) {
        this.loged = loged;
    }

    public Integer getSortCode() {
        return this.sortCode;
    }

    public void setSortCode(Integer sortCode) {
        this.sortCode = sortCode;
    }

    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    public Boolean getMatchRestful() {
        return this.matchRestful;
    }

    public void setMatchRestful(Boolean matchRestful) {
        this.matchRestful = matchRestful;
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public void setNamespaceId(String namespaceId) {
        this.namespaceId = namespaceId;
    }

    public static RuleDOBuilder builder() {
        return new RuleDOBuilder();
    }

    public static RuleDO buildRuleDO(RuleDTO ruleDTO) {
        return Optional.ofNullable(ruleDTO).map(item -> {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            RuleDO ruleDO = RuleDO.builder().selectorId(item.getSelectorId()).matchMode(item.getMatchMode()).ruleName(item.getName()).enabled(item.getEnabled()).loged(item.getLoged()).sortCode(item.getSort()).handle(item.getHandle()).matchRestful(item.getMatchRestful()).dateUpdated(currentTime).namespaceId(item.getNamespaceId()).build();
            if (StringUtils.isEmpty((CharSequence)item.getId())) {
                ruleDO.setId(UUIDUtils.getInstance().generateShortUuid());
                ruleDO.setDateCreated(currentTime);
            } else {
                ruleDO.setId(item.getId());
            }
            return ruleDO;
        }).orElse(null);
    }

    public static RuleData transFrom(RuleDO ruleDO, String pluginName, List<ConditionData> conditionDataList, List<ConditionData> beforeConditionDataList) {
        return RuleData.builder().id(ruleDO.getId()).name(ruleDO.getRuleName()).pluginName(pluginName).selectorId(ruleDO.getSelectorId()).matchMode(ruleDO.getMatchMode()).sort(ruleDO.getSortCode()).enabled(ruleDO.getEnabled()).loged(ruleDO.getLoged()).handle(ruleDO.getHandle()).matchRestful(ruleDO.getMatchRestful()).conditionDataList(conditionDataList).beforeConditionDataList(beforeConditionDataList).namespaceId(ruleDO.getNamespaceId()).build();
    }

    public static RuleData transFrom(RuleDO ruleDO, String pluginName, List<ConditionData> conditionDataList) {
        return RuleDO.transFrom(ruleDO, pluginName, conditionDataList, Collections.emptyList());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (Objects.isNull(o) || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RuleDO ruleDO = (RuleDO)o;
        return Objects.equals(this.selectorId, ruleDO.selectorId) && Objects.equals(this.matchMode, ruleDO.matchMode) && Objects.equals(this.ruleName, ruleDO.ruleName) && Objects.equals(this.enabled, ruleDO.enabled) && Objects.equals(this.loged, ruleDO.loged) && Objects.equals(this.sortCode, ruleDO.sortCode) && Objects.equals(this.handle, ruleDO.handle) && Objects.equals(this.matchRestful, ruleDO.matchRestful) && Objects.equals(this.namespaceId, ruleDO.namespaceId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.selectorId, this.matchMode, this.ruleName, this.enabled, this.loged, this.sortCode, this.handle, this.matchRestful, this.namespaceId);
    }

    public static final class RuleDOBuilder {
        private String id;
        private Timestamp dateCreated;
        private Timestamp dateUpdated;
        private String selectorId;
        private Integer matchMode;
        private String ruleName;
        private Boolean enabled;
        private Boolean loged;
        private Integer sortCode;
        private String handle;
        private Boolean matchRestful;
        private String namespaceId;

        private RuleDOBuilder() {
        }

        public RuleDOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public RuleDOBuilder dateCreated(Timestamp dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public RuleDOBuilder dateUpdated(Timestamp dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public RuleDOBuilder selectorId(String selectorId) {
            this.selectorId = selectorId;
            return this;
        }

        public RuleDOBuilder matchMode(Integer matchMode) {
            this.matchMode = matchMode;
            return this;
        }

        public RuleDOBuilder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public RuleDOBuilder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public RuleDOBuilder loged(Boolean loged) {
            this.loged = loged;
            return this;
        }

        public RuleDOBuilder sortCode(Integer sortCode) {
            this.sortCode = sortCode;
            return this;
        }

        public RuleDOBuilder handle(String handle) {
            this.handle = handle;
            return this;
        }

        public RuleDOBuilder matchRestful(Boolean matchRestful) {
            this.matchRestful = matchRestful;
            return this;
        }

        public RuleDOBuilder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        public RuleDO build() {
            RuleDO ruleDO = new RuleDO();
            ruleDO.setId(this.id);
            ruleDO.setDateCreated(this.dateCreated);
            ruleDO.setDateUpdated(this.dateUpdated);
            ruleDO.setSelectorId(this.selectorId);
            ruleDO.setMatchMode(this.matchMode);
            ruleDO.setRuleName(this.ruleName);
            ruleDO.setEnabled(this.enabled);
            ruleDO.setLoged(this.loged);
            ruleDO.setSortCode(this.sortCode);
            ruleDO.setHandle(this.handle);
            ruleDO.setMatchRestful(this.matchRestful);
            ruleDO.setNamespaceId(this.namespaceId);
            return ruleDO;
        }
    }
}

