/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.entity;

import java.sql.Timestamp;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.DataPermissionDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.common.utils.UUIDUtils;

public final class DataPermissionDO
extends BaseDO {
    private static final long serialVersionUID = 8732493731708038311L;
    private String userId;
    private String dataId;
    private Integer dataType;

    public DataPermissionDO() {
    }

    public DataPermissionDO(String userId, String dataId, Integer dataType) {
        this.userId = userId;
        this.dataId = dataId;
        this.dataType = dataType;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getDataId() {
        return this.dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public Integer getDataType() {
        return this.dataType;
    }

    public void setDataType(Integer dataType) {
        this.dataType = dataType;
    }

    public static DataPermissionDOBuilder builder() {
        return new DataPermissionDOBuilder();
    }

    public static DataPermissionDO buildPermissionDO(DataPermissionDTO dataPermissionDTO) {
        return Optional.ofNullable(dataPermissionDTO).map(item -> {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            DataPermissionDO dataPermissionDo = DataPermissionDO.builder().userId(item.getUserId()).dataId(item.getDataId()).dataType(item.getDataType()).build();
            if (StringUtils.isEmpty((CharSequence)item.getId())) {
                dataPermissionDo.setId(UUIDUtils.getInstance().generateShortUuid());
                dataPermissionDo.setDateCreated(currentTime);
            } else {
                dataPermissionDo.setId(item.getId());
            }
            return dataPermissionDo;
        }).orElse(null);
    }

    public static DataPermissionDO buildCreatePermissionDO(String dataId, String userId, Integer dataType) {
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        return DataPermissionDO.builder().userId(userId).dataId(dataId).dataType(dataType).id(UUIDUtils.getInstance().generateShortUuid()).dateCreated(currentTime).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataPermissionDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DataPermissionDO that = (DataPermissionDO)o;
        return Objects.equals(this.userId, that.userId) && Objects.equals(this.dataId, that.dataId) && Objects.equals(this.dataType, that.dataType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userId, this.dataId, this.dataType);
    }

    public static final class DataPermissionDOBuilder {
        private String id;
        private Timestamp dateCreated;
        private Timestamp dateUpdated;
        private String userId;
        private String dataId;
        private Integer dataType;

        private DataPermissionDOBuilder() {
        }

        public DataPermissionDOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public DataPermissionDOBuilder dateCreated(Timestamp dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public DataPermissionDOBuilder dateUpdated(Timestamp dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public DataPermissionDOBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public DataPermissionDOBuilder dataId(String dataId) {
            this.dataId = dataId;
            return this;
        }

        public DataPermissionDOBuilder dataType(Integer dataType) {
            this.dataType = dataType;
            return this;
        }

        public DataPermissionDO build() {
            DataPermissionDO dataPermissionDO = new DataPermissionDO();
            dataPermissionDO.setId(this.id);
            dataPermissionDO.setDateCreated(this.dateCreated);
            dataPermissionDO.setDateUpdated(this.dateUpdated);
            dataPermissionDO.setUserId(this.userId);
            dataPermissionDO.setDataId(this.dataId);
            dataPermissionDO.setDataType(this.dataType);
            return dataPermissionDO;
        }
    }
}

