/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.apache.shenyu.admin.aspect.annotation.RestApi;
import org.apache.shenyu.admin.mapper.NamespaceMapper;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.AlertReceiverQuery;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.service.AlertReceiverService;
import org.apache.shenyu.admin.validation.annotation.Existed;
import org.apache.shenyu.alert.model.AlertReceiverDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@RestApi(value={"/alert/receiver"})
public class AlertReceiverController {
    @Autowired
    private AlertReceiverService alertReceiverService;

    @PostMapping
    public ShenyuAdminResult addReceiver(@Valid @RequestBody AlertReceiverDTO alertReceiverDTO) {
        this.alertReceiverService.addReceiver(alertReceiverDTO);
        return ShenyuAdminResult.success("create success");
    }

    @PutMapping
    public ShenyuAdminResult editReceiver(@Valid @RequestBody AlertReceiverDTO alertReceiverDTO) {
        this.alertReceiverService.updateReceiver(alertReceiverDTO);
        return ShenyuAdminResult.success("update success");
    }

    @DeleteMapping(value={"/batch"})
    public ShenyuAdminResult deleteReceiver(@RequestBody @NotEmpty List<@NotBlank String> ids) {
        this.alertReceiverService.deleteReceiver(ids);
        return ShenyuAdminResult.success("delete success");
    }

    @GetMapping(value={"/{id}"})
    public ShenyuAdminResult getReceiverDetail(@PathVariable(value="id") String id) {
        AlertReceiverDTO receiverDTO = this.alertReceiverService.detail(id);
        return ShenyuAdminResult.success(receiverDTO);
    }

    @GetMapping
    public ShenyuAdminResult getReceivers(@RequestParam @NotNull Integer currentPage, @RequestParam @NotNull Integer pageSize, @Valid @Existed(message="namespaceId is not existed", provider=NamespaceMapper.class) @Valid @Existed(message="namespaceId is not existed", provider=NamespaceMapper.class) String namespaceId) {
        CommonPager<AlertReceiverDTO> commonPager = this.alertReceiverService.listByPage(new AlertReceiverQuery(new PageParameter(currentPage, pageSize), namespaceId));
        return ShenyuAdminResult.success(commonPager);
    }

    @PostMapping(path={"/test"})
    public ShenyuAdminResult sendTestMsg(@Valid @RequestBody AlertReceiverDTO alertReceiverDTO) {
        try {
            boolean sendFlag = this.alertReceiverService.sendTestMsg(alertReceiverDTO);
            if (sendFlag) {
                return ShenyuAdminResult.success();
            }
            return ShenyuAdminResult.error("Notify service not available, please check config!");
        }
        catch (Exception e) {
            return ShenyuAdminResult.error("Notify service error: " + e.getMessage());
        }
    }
}

