/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.discovery;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.discovery.listener.DataChangedEventListener;
import org.apache.shenyu.admin.discovery.listener.DiscoveryDataChangedEvent;
import org.apache.shenyu.admin.discovery.parse.KeyValueParser;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.mapper.DiscoveryUpstreamMapper;
import org.apache.shenyu.admin.model.entity.DiscoveryUpstreamDO;
import org.apache.shenyu.admin.transfer.DiscoveryTransfer;
import org.apache.shenyu.common.dto.DiscoverySyncData;
import org.apache.shenyu.common.dto.DiscoveryUpstreamData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.transaction.annotation.Transactional;

public class DiscoveryDataChangedEventSyncListener
implements DataChangedEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryDataChangedEventSyncListener.class);
    private final KeyValueParser keyValueParser;
    private final ApplicationEventPublisher eventPublisher;
    private final DiscoveryUpstreamMapper discoveryUpstreamMapper;
    private final List<DiscoverySyncData> discoverySyncDataList = new ArrayList<DiscoverySyncData>();
    private final String discoveryId;

    public DiscoveryDataChangedEventSyncListener(ApplicationEventPublisher eventPublisher, DiscoveryUpstreamMapper discoveryUpstreamMapper, KeyValueParser keyValueParser, DiscoverySyncData contextInfo, String discoveryId) {
        this.eventPublisher = eventPublisher;
        this.keyValueParser = keyValueParser;
        this.discoveryId = discoveryId;
        this.discoveryUpstreamMapper = discoveryUpstreamMapper;
        this.discoverySyncDataList.add(contextInfo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void onChange(DiscoveryDataChangedEvent event) {
        DiscoveryDataChangedEvent.Event currentEvent = event.getEvent();
        if (DiscoveryDataChangedEvent.Event.IGNORED.equals((Object)currentEvent)) {
            return;
        }
        this.discoverySyncDataList.forEach(discoverySyncData -> {
            LOG.info("DiscoveryDataChangedEventSyncListener watch discoveryId {} discoveryHandlerId {} selectorId {} event {}", new Object[]{this.discoveryId, discoverySyncData.getDiscoveryHandlerId(), discoverySyncData.getSelectorId(), event});
            this.syncData0(event, (DiscoverySyncData)discoverySyncData, currentEvent);
        });
    }

    private void syncData0(DiscoveryDataChangedEvent event, DiscoverySyncData discoverySyncData, DiscoveryDataChangedEvent.Event currentEvent) {
        DiscoverySyncData syncData = this.buildProxySelectorData(discoverySyncData, event.getValue());
        List upstreamDataList = syncData.getUpstreamDataList();
        if (CollectionUtils.isEmpty((Collection)upstreamDataList)) {
            LOG.warn("Discover EventSync proxySelectorData discoveryUpstreamList is empty syncData {}", (Object)syncData);
            return;
        }
        String discoveryHandlerId = discoverySyncData.getDiscoveryHandlerId();
        switch (currentEvent) {
            case ADDED: {
                upstreamDataList.forEach(d -> {
                    try {
                        DiscoveryUpstreamDO discoveryUpstreamDO = this.discoveryUpstreamMapper.selectByDiscoveryHandlerIdAndUrl(discoveryHandlerId, d.getUrl());
                        if (Objects.isNull(discoveryUpstreamDO)) {
                            d.setId(UUIDUtils.getInstance().generateShortUuid());
                            d.setDateCreated(new Timestamp(System.currentTimeMillis()));
                            d.setDateUpdated(new Timestamp(System.currentTimeMillis()));
                            this.discoveryUpstreamMapper.insert(DiscoveryTransfer.INSTANCE.mapToDo((DiscoveryUpstreamData)d));
                            LOG.info("[DiscoveryDataChangedEventSyncListener] ADDED Upstream {}", (Object)d.getUrl());
                        }
                    }
                    catch (DuplicateKeyException ex) {
                        LOG.info("[DiscoveryDataChangedEventSyncListener]  Upstream {} exist", (Object)d.getUrl());
                    }
                });
                break;
            }
            case UPDATED: {
                upstreamDataList.stream().map(DiscoveryTransfer.INSTANCE::mapToDo).forEach(discoveryUpstreamDO -> {
                    discoveryUpstreamDO.setDiscoveryHandlerId(discoveryHandlerId);
                    int effect = this.discoveryUpstreamMapper.updateDiscoveryHandlerIdAndUrl((DiscoveryUpstreamDO)discoveryUpstreamDO);
                    LOG.info("[DiscoveryDataChangedEventSyncListener] UPDATE Upstream {}, effect = {} ", (Object)discoveryUpstreamDO.getUrl(), (Object)effect);
                });
                break;
            }
            case DELETED: {
                if (!CollectionUtils.isNotEmpty((Collection)upstreamDataList)) break;
                upstreamDataList.forEach(up -> {
                    this.discoveryUpstreamMapper.deleteByUrl(discoveryHandlerId, up.getUrl());
                    LOG.info("[DiscoveryDataChangedEventSyncListener] DELETE Upstream {}", (Object)up.getUrl());
                });
                break;
            }
            default: {
                throw new IllegalStateException("DiscoveryDataChangedEventSyncListener find IllegalState");
            }
        }
        DataChangedEvent dataChangedEvent = new DataChangedEvent(ConfigGroupEnum.DISCOVER_UPSTREAM, DataEventTypeEnum.UPDATE, Collections.singletonList(syncData));
        this.eventPublisher.publishEvent((ApplicationEvent)dataChangedEvent);
    }

    private DiscoverySyncData buildProxySelectorData(DiscoverySyncData discoverySyncData, String value) {
        List<Object> discoveryUpstreamDTOS = this.keyValueParser.parseValue(value);
        discoveryUpstreamDTOS.forEach(discoveryUpstreamData -> {
            if (StringUtils.isBlank((CharSequence)discoveryUpstreamData.getNamespaceId())) {
                discoveryUpstreamData.setNamespaceId("649330b6-c2d7-4edc-be8e-8a54df9eb385");
            }
        });
        discoveryUpstreamDTOS = discoveryUpstreamDTOS.stream().filter(upstreamData -> discoverySyncData.getNamespaceId().equals(upstreamData.getNamespaceId())).collect(Collectors.toList());
        discoveryUpstreamDTOS.forEach(discoveryUpstreamData -> {
            discoveryUpstreamData.setDiscoveryHandlerId(discoverySyncData.getDiscoveryHandlerId());
            if (StringUtils.isBlank((CharSequence)discoveryUpstreamData.getProtocol())) {
                discoveryUpstreamData.setProtocol(this.discoverySupportProtocol(discoverySyncData.getPluginName()));
            }
        });
        DiscoverySyncData data = new DiscoverySyncData();
        data.setUpstreamDataList(discoveryUpstreamDTOS);
        data.setSelectorId(discoverySyncData.getSelectorId());
        data.setSelectorName(discoverySyncData.getSelectorName());
        data.setPluginName(discoverySyncData.getPluginName());
        data.setNamespaceId(discoverySyncData.getNamespaceId());
        return data;
    }

    @Override
    public void addListener(DiscoverySyncData discoverySyncData) {
        if (this.discoverySyncDataList.stream().noneMatch(data -> data.getSelectorId().equals(discoverySyncData.getSelectorId()) && data.getDiscoveryHandlerId().equals(discoverySyncData.getDiscoveryHandlerId()))) {
            this.discoverySyncDataList.add(discoverySyncData);
            LOG.info("[DiscoveryDataChangedEventSyncListener] add discoverySyncData {}", (Object)discoverySyncData);
        }
    }

    private String discoverySupportProtocol(String pluginName) {
        String pluginNameLower;
        switch (pluginNameLower = pluginName.toLowerCase()) {
            case "divide": 
            case "grpc": {
                return "http://";
            }
            case "websocket": {
                return "ws://";
            }
        }
        return "";
    }
}

