/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.exception.ShenyuAdminException;
import org.apache.shenyu.admin.mapper.AppAuthMapper;
import org.apache.shenyu.admin.mapper.AuthPathMapper;
import org.apache.shenyu.admin.mapper.DiscoveryMapper;
import org.apache.shenyu.admin.mapper.MetaDataMapper;
import org.apache.shenyu.admin.mapper.NamespaceMapper;
import org.apache.shenyu.admin.mapper.NamespacePluginRelMapper;
import org.apache.shenyu.admin.mapper.RuleMapper;
import org.apache.shenyu.admin.mapper.SelectorMapper;
import org.apache.shenyu.admin.model.dto.NamespaceDTO;
import org.apache.shenyu.admin.model.entity.AppAuthDO;
import org.apache.shenyu.admin.model.entity.MetaDataDO;
import org.apache.shenyu.admin.model.entity.NamespaceDO;
import org.apache.shenyu.admin.model.entity.RuleDO;
import org.apache.shenyu.admin.model.entity.SelectorDO;
import org.apache.shenyu.admin.model.event.namespace.NamespaceCreatedEvent;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.NamespaceQuery;
import org.apache.shenyu.admin.model.vo.NamespacePluginVO;
import org.apache.shenyu.admin.model.vo.NamespaceVO;
import org.apache.shenyu.admin.service.NamespaceService;
import org.apache.shenyu.admin.service.NamespaceUserService;
import org.apache.shenyu.admin.service.publish.NamespaceEventPublisher;
import org.apache.shenyu.admin.transfer.NamespaceTransfer;
import org.apache.shenyu.admin.utils.SessionUtil;
import org.apache.shenyu.common.utils.NamespaceIDUtils;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class NamespaceServiceImpl
implements NamespaceService {
    private final NamespaceMapper namespaceMapper;
    private final NamespaceUserService namespaceUserService;
    private final NamespaceEventPublisher namespaceEventPublisher;
    private final SelectorMapper selectorMapper;
    private final RuleMapper ruleMapper;
    private final AuthPathMapper authPathMapper;
    private final MetaDataMapper metaDataMapper;
    private final DiscoveryMapper discoveryMapper;
    private final NamespacePluginRelMapper namespacePluginRelMapper;
    private final AppAuthMapper appAuthMapper;

    public NamespaceServiceImpl(NamespaceMapper namespaceMapper, NamespaceUserService namespaceUserService, NamespaceEventPublisher namespaceEventPublisher, NamespacePluginRelMapper namespacePluginRelMapper, SelectorMapper selectorMapper, RuleMapper ruleMapper, AuthPathMapper authPathMapper, MetaDataMapper metaDataMapper, DiscoveryMapper discoveryMapper, AppAuthMapper appAuthMapper) {
        this.namespaceMapper = namespaceMapper;
        this.namespaceUserService = namespaceUserService;
        this.namespaceEventPublisher = namespaceEventPublisher;
        this.namespacePluginRelMapper = namespacePluginRelMapper;
        this.selectorMapper = selectorMapper;
        this.ruleMapper = ruleMapper;
        this.authPathMapper = authPathMapper;
        this.metaDataMapper = metaDataMapper;
        this.discoveryMapper = discoveryMapper;
        this.appAuthMapper = appAuthMapper;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public NamespaceVO createOrUpdate(NamespaceDTO namespaceDTO) {
        return StringUtils.isBlank((CharSequence)namespaceDTO.getId()) ? this.create(namespaceDTO) : this.update(namespaceDTO);
    }

    @Override
    public CommonPager<NamespaceVO> listByPage(NamespaceQuery namespaceQuery) {
        List<String> namespaceIds;
        if (SessionUtil.isAdmin()) {
            List<NamespaceDO> allList = this.namespaceMapper.selectAll();
            namespaceIds = allList.stream().map(NamespaceDO::getNamespaceId).toList();
        } else {
            namespaceIds = this.namespaceUserService.listNamespaceIdByUserId(SessionUtil.visitorId());
        }
        if (CollectionUtils.isEmpty(namespaceIds)) {
            return new CommonPager<NamespaceVO>();
        }
        namespaceQuery.setNamespaceIds(namespaceIds);
        return PageResultUtils.result(namespaceQuery.getPageParameter(), () -> this.namespaceMapper.countByQuery(namespaceQuery), () -> this.namespaceMapper.selectByQuery(namespaceQuery).stream().map(NamespaceTransfer.INSTANCE::mapToVo).collect(Collectors.toList()));
    }

    @Override
    public String delete(List<String> ids) {
        if (ids.contains("1")) {
            throw new ShenyuAdminException("The default namespace cannot delete\uff01");
        }
        List<String> namespaceIdList = this.namespaceMapper.selectByIds(ids).stream().map(NamespaceDO::getNamespaceId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(namespaceIdList)) {
            throw new ShenyuAdminException("The namespace(s) does not exist\uff01");
        }
        List<RuleDO> ruleDOList = this.ruleMapper.selectAllByNamespaceIds(namespaceIdList);
        if (CollectionUtils.isNotEmpty(ruleDOList)) {
            throw new ShenyuAdminException("rule exist under those namespace!");
        }
        List<SelectorDO> selectorDOS = this.selectorMapper.selectAllByNamespaceIds(namespaceIdList);
        if (CollectionUtils.isNotEmpty(selectorDOS)) {
            throw new ShenyuAdminException("selector exist under those namespace!");
        }
        List<NamespacePluginVO> namespacePluginVOS = this.namespacePluginRelMapper.selectAllByNamespaceIds(namespaceIdList);
        if (CollectionUtils.isNotEmpty(namespacePluginVOS)) {
            throw new ShenyuAdminException("Plugins exist under those namespace!");
        }
        List<MetaDataDO> metaDataDOList = this.metaDataMapper.findAllByNamespaceIds(namespaceIdList);
        if (CollectionUtils.isNotEmpty(metaDataDOList)) {
            throw new ShenyuAdminException("metaData exist under those namespace!");
        }
        List<AppAuthDO> appPathDOList = this.appAuthMapper.findByNamespaceIds(namespaceIdList);
        if (CollectionUtils.isNotEmpty(appPathDOList)) {
            throw new ShenyuAdminException("appPath exist under those namespace!");
        }
        this.namespaceMapper.deleteByIds(ids);
        return "delete success";
    }

    @Override
    public NamespaceVO findById(String id) {
        return NamespaceTransfer.INSTANCE.mapToVo(this.namespaceMapper.selectById(id));
    }

    @Override
    public NamespaceVO findByNamespaceId(String namespaceId) {
        return NamespaceTransfer.INSTANCE.mapToVo(this.namespaceMapper.selectByNamespaceId(namespaceId));
    }

    @Override
    public List<NamespaceVO> list(String name) {
        if (SessionUtil.isAdmin()) {
            List<NamespaceDO> allList = this.namespaceMapper.selectAll();
            return allList.stream().map(NamespaceTransfer.INSTANCE::mapToVo).collect(Collectors.toList());
        }
        List<String> namespaceIds = this.namespaceUserService.listNamespaceIdByUserId(SessionUtil.visitorId());
        if (CollectionUtils.isEmpty(namespaceIds)) {
            return Lists.newArrayList();
        }
        List<NamespaceDO> namespaceDOS = this.namespaceMapper.selectByNamespaceIdsAndName(namespaceIds, name);
        if (CollectionUtils.isEmpty(namespaceDOS)) {
            return Lists.newArrayList();
        }
        return namespaceDOS.stream().map(NamespaceTransfer.INSTANCE::mapToVo).collect(Collectors.toList());
    }

    @Override
    public List<NamespaceVO> listAll() {
        List<NamespaceDO> namespaceDOS = this.namespaceMapper.selectAll();
        return namespaceDOS.stream().map(NamespaceTransfer.INSTANCE::mapToVo).collect(Collectors.toList());
    }

    private NamespaceVO create(NamespaceDTO namespaceDTO) {
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        String id = UUIDUtils.getInstance().generateShortUuid();
        String namespaceId = StringUtils.defaultString((String)namespaceDTO.getNamespaceId(), (String)NamespaceIDUtils.getInstance().generateNamespaceID());
        NamespaceDO namespaceDO = NamespaceDO.builder().id(id).namespaceId(namespaceId).name(namespaceDTO.getName()).description(namespaceDTO.getDescription()).dateCreated(currentTime).dateUpdated(currentTime).build();
        this.namespaceMapper.insert(namespaceDO);
        this.namespaceEventPublisher.publish(new NamespaceCreatedEvent(namespaceDO, SessionUtil.visitorId()));
        return NamespaceTransfer.INSTANCE.mapToVo(namespaceDO);
    }

    private NamespaceVO update(NamespaceDTO namespaceDTO) {
        if (Objects.isNull(namespaceDTO) || Objects.isNull(namespaceDTO.getNamespaceId())) {
            throw new ShenyuAdminException("namespace is not exist");
        }
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        NamespaceDO namespaceDO = NamespaceDO.builder().namespaceId(namespaceDTO.getNamespaceId()).name(namespaceDTO.getName()).description(namespaceDTO.getDescription()).dateUpdated(currentTime).build();
        return this.namespaceMapper.updateSelective(namespaceDO) > 0 ? NamespaceTransfer.INSTANCE.mapToVo(namespaceDO) : null;
    }
}

