/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener.websocket;

import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.listener.DataChangedListener;
import org.apache.shenyu.admin.listener.websocket.WebsocketCollector;
import org.apache.shenyu.common.dto.AppAuthData;
import org.apache.shenyu.common.dto.DiscoverySyncData;
import org.apache.shenyu.common.dto.MetaData;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.ProxySelectorData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.WebsocketData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.utils.GsonUtils;

public class WebsocketDataChangedListener
implements DataChangedListener {
    public void onPluginChanged(List<PluginData> pluginDataList, DataEventTypeEnum eventType) {
        WebsocketData websocketData = new WebsocketData(ConfigGroupEnum.PLUGIN.name(), eventType.name(), pluginDataList);
        if (CollectionUtils.isNotEmpty(pluginDataList)) {
            String namespaceId = pluginDataList.stream().map(value -> StringUtils.defaultString((String)value.getNamespaceId(), (String)"649330b6-c2d7-4edc-be8e-8a54df9eb385")).findFirst().get();
            WebsocketCollector.send(namespaceId, GsonUtils.getInstance().toJson((Object)websocketData), eventType);
        }
    }

    public void onSelectorChanged(List<SelectorData> selectorDataList, DataEventTypeEnum eventType) {
        WebsocketData websocketData = new WebsocketData(ConfigGroupEnum.SELECTOR.name(), eventType.name(), selectorDataList);
        if (CollectionUtils.isNotEmpty(selectorDataList)) {
            String namespaceId = selectorDataList.stream().map(value -> StringUtils.defaultString((String)value.getNamespaceId(), (String)"649330b6-c2d7-4edc-be8e-8a54df9eb385")).findFirst().get();
            WebsocketCollector.send(namespaceId, GsonUtils.getInstance().toJson((Object)websocketData), eventType);
        }
    }

    public void onRuleChanged(List<RuleData> ruleDataList, DataEventTypeEnum eventType) {
        WebsocketData configData = new WebsocketData(ConfigGroupEnum.RULE.name(), eventType.name(), ruleDataList);
        if (CollectionUtils.isNotEmpty(ruleDataList)) {
            String namespaceId = ruleDataList.stream().map(value -> StringUtils.defaultString((String)value.getNamespaceId(), (String)"649330b6-c2d7-4edc-be8e-8a54df9eb385")).findFirst().get();
            WebsocketCollector.send(namespaceId, GsonUtils.getInstance().toJson((Object)configData), eventType);
        }
    }

    public void onAppAuthChanged(List<AppAuthData> appAuthDataList, DataEventTypeEnum eventType) {
        WebsocketData configData = new WebsocketData(ConfigGroupEnum.APP_AUTH.name(), eventType.name(), appAuthDataList);
        if (CollectionUtils.isNotEmpty(appAuthDataList)) {
            String namespaceId = appAuthDataList.stream().map(value -> StringUtils.defaultString((String)value.getNamespaceId(), (String)"649330b6-c2d7-4edc-be8e-8a54df9eb385")).findFirst().get();
            WebsocketCollector.send(namespaceId, GsonUtils.getInstance().toJson((Object)configData), eventType);
        }
    }

    public void onMetaDataChanged(List<MetaData> metaDataList, DataEventTypeEnum eventType) {
        WebsocketData configData = new WebsocketData(ConfigGroupEnum.META_DATA.name(), eventType.name(), metaDataList);
        if (CollectionUtils.isNotEmpty(metaDataList)) {
            String namespaceId = metaDataList.stream().map(value -> StringUtils.defaultString((String)value.getNamespaceId(), (String)"649330b6-c2d7-4edc-be8e-8a54df9eb385")).findFirst().get();
            WebsocketCollector.send(namespaceId, GsonUtils.getInstance().toJson((Object)configData), eventType);
        }
    }

    public void onProxySelectorChanged(List<ProxySelectorData> proxySelectorDataList, DataEventTypeEnum eventType) {
        WebsocketData configData = new WebsocketData(ConfigGroupEnum.PROXY_SELECTOR.name(), eventType.name(), proxySelectorDataList);
        if (CollectionUtils.isNotEmpty(proxySelectorDataList)) {
            String namespaceId = proxySelectorDataList.stream().map(value -> StringUtils.defaultString((String)value.getNamespaceId(), (String)"649330b6-c2d7-4edc-be8e-8a54df9eb385")).findFirst().get();
            WebsocketCollector.send(namespaceId, GsonUtils.getInstance().toJson((Object)configData), eventType);
        }
    }

    public void onDiscoveryUpstreamChanged(List<DiscoverySyncData> discoveryUpstreamList, DataEventTypeEnum eventType) {
        WebsocketData configData = new WebsocketData(ConfigGroupEnum.DISCOVER_UPSTREAM.name(), eventType.name(), discoveryUpstreamList);
        if (CollectionUtils.isNotEmpty(discoveryUpstreamList)) {
            String namespaceId = discoveryUpstreamList.stream().map(value -> StringUtils.defaultString((String)value.getNamespaceId(), (String)"649330b6-c2d7-4edc-be8e-8a54df9eb385")).findFirst().get();
            WebsocketCollector.send(namespaceId, GsonUtils.getInstance().toJson((Object)configData), eventType);
        }
    }
}

