/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.controller;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.apache.shenyu.admin.aspect.annotation.RestApi;
import org.apache.shenyu.admin.mapper.NamespaceMapper;
import org.apache.shenyu.admin.model.dto.ProxySelectorAddDTO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageParameter;
import org.apache.shenyu.admin.model.query.ProxySelectorQuery;
import org.apache.shenyu.admin.model.result.ShenyuAdminResult;
import org.apache.shenyu.admin.model.vo.ProxySelectorVO;
import org.apache.shenyu.admin.service.ProxySelectorService;
import org.apache.shenyu.admin.validation.annotation.Existed;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;

@RestApi(value={"/proxy-selector"})
public class ProxySelectorController {
    private final ProxySelectorService proxySelectorService;

    public ProxySelectorController(ProxySelectorService proxySelectorService) {
        this.proxySelectorService = proxySelectorService;
    }

    @GetMapping(value={""})
    public ShenyuAdminResult queryProxySelector(String name, @NotNull Integer currentPage, @NotNull Integer pageSize, @Existed(message="namespace is not existed", provider=NamespaceMapper.class) @Existed(message="namespace is not existed", provider=NamespaceMapper.class) String namespaceId) {
        CommonPager<ProxySelectorVO> commonPager = this.proxySelectorService.listByPage(new ProxySelectorQuery(name, new PageParameter(currentPage, pageSize), namespaceId));
        return ShenyuAdminResult.success("query success", commonPager);
    }

    @PutMapping(value={"/{id}"})
    public ShenyuAdminResult updateProxySelector(@PathVariable(value="id") String id, @Valid @RequestBody ProxySelectorAddDTO proxySelectorAddDTO) {
        proxySelectorAddDTO.setId(id);
        return ShenyuAdminResult.success(this.proxySelectorService.createOrUpdate(proxySelectorAddDTO));
    }

    @DeleteMapping(value={"/batch"})
    public ShenyuAdminResult deleteProxySelectors(@NotEmpty @RequestBody List<@NotBlank String> ids) {
        return ShenyuAdminResult.success(this.proxySelectorService.delete(ids));
    }

    @PostMapping(value={"addProxySelector"})
    public ShenyuAdminResult addProxySelector(@RequestBody @Valid ProxySelectorAddDTO proxySelectorAddDTO) {
        return ShenyuAdminResult.success(this.proxySelectorService.create(proxySelectorAddDTO), null);
    }

    @PutMapping(value={"fetch/{discoveryHandlerId}"})
    public ShenyuAdminResult fetchData(@PathVariable(value="discoveryHandlerId") String discoveryHandlerId) {
        this.proxySelectorService.fetchData(discoveryHandlerId);
        return ShenyuAdminResult.success();
    }

    @PostMapping(value={"binding"})
    public ShenyuAdminResult bindingSelector(@RequestBody @Valid ProxySelectorAddDTO proxySelectorAddDTO) {
        return ShenyuAdminResult.success(this.proxySelectorService.bindingDiscoveryHandler(proxySelectorAddDTO), null);
    }
}

