/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.common.enums.LogicalOperator;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.BinaryOperationExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.FunctionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.InExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.TypeCastExpression;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;

public final class ExpressionExtractUtils {
    public static Collection<AndPredicate> getAndPredicates(ExpressionSegment expression) {
        LinkedList<AndPredicate> result = new LinkedList<AndPredicate>();
        ExpressionExtractUtils.extractAndPredicates(result, expression);
        return result;
    }

    private static void extractAndPredicates(Collection<AndPredicate> result, ExpressionSegment expression) {
        if (!(expression instanceof BinaryOperationExpression)) {
            result.add(ExpressionExtractUtils.createAndPredicate(expression));
            return;
        }
        BinaryOperationExpression binaryExpression = (BinaryOperationExpression)expression;
        Optional<LogicalOperator> logicalOperator = LogicalOperator.valueFrom(binaryExpression.getOperator());
        if (logicalOperator.isPresent() && LogicalOperator.OR == logicalOperator.get()) {
            ExpressionExtractUtils.extractAndPredicates(result, binaryExpression.getLeft());
            ExpressionExtractUtils.extractAndPredicates(result, binaryExpression.getRight());
        } else if (logicalOperator.isPresent() && LogicalOperator.AND == logicalOperator.get()) {
            Collection<AndPredicate> predicates = ExpressionExtractUtils.getAndPredicates(binaryExpression.getRight());
            for (AndPredicate each : ExpressionExtractUtils.getAndPredicates(binaryExpression.getLeft())) {
                ExpressionExtractUtils.extractCombinedAndPredicates(result, each, predicates);
            }
        } else {
            result.add(ExpressionExtractUtils.createAndPredicate(expression));
        }
    }

    private static void extractCombinedAndPredicates(Collection<AndPredicate> result, AndPredicate current, Collection<AndPredicate> predicates) {
        for (AndPredicate each : predicates) {
            AndPredicate predicate = new AndPredicate();
            predicate.getPredicates().addAll(current.getPredicates());
            predicate.getPredicates().addAll(each.getPredicates());
            result.add(predicate);
        }
    }

    private static AndPredicate createAndPredicate(ExpressionSegment expression) {
        AndPredicate result = new AndPredicate();
        result.getPredicates().add(expression);
        return result;
    }

    public static List<ParameterMarkerExpressionSegment> getParameterMarkerExpressions(Collection<ExpressionSegment> expressions) {
        ArrayList<ParameterMarkerExpressionSegment> result = new ArrayList<ParameterMarkerExpressionSegment>();
        ExpressionExtractUtils.extractParameterMarkerExpressions(result, expressions);
        return result;
    }

    private static void extractParameterMarkerExpressions(List<ParameterMarkerExpressionSegment> result, Collection<ExpressionSegment> expressions) {
        for (ExpressionSegment each : expressions) {
            if (each instanceof ParameterMarkerExpressionSegment) {
                result.add((ParameterMarkerExpressionSegment)each);
            }
            if (each instanceof BinaryOperationExpression) {
                ExpressionExtractUtils.extractParameterMarkerExpressions(result, Collections.singleton(((BinaryOperationExpression)each).getLeft()));
                ExpressionExtractUtils.extractParameterMarkerExpressions(result, Collections.singleton(((BinaryOperationExpression)each).getRight()));
            }
            if (each instanceof FunctionSegment) {
                ExpressionExtractUtils.extractParameterMarkerExpressions(result, ((FunctionSegment)each).getParameters());
            }
            if (each instanceof TypeCastExpression) {
                ExpressionExtractUtils.extractParameterMarkerExpressions(result, Collections.singleton(((TypeCastExpression)each).getExpression()));
            }
            if (!(each instanceof InExpression)) continue;
            ExpressionExtractUtils.extractParameterMarkerExpressions(result, ((InExpression)each).getExpressionList());
        }
    }

    public static void extractJoinConditions(Collection<BinaryOperationExpression> joinConditions, Collection<WhereSegment> whereSegments) {
        for (WhereSegment each : whereSegments) {
            if (!(each.getExpr() instanceof BinaryOperationExpression) || !(((BinaryOperationExpression)each.getExpr()).getLeft() instanceof ColumnSegment) || !(((BinaryOperationExpression)each.getExpr()).getRight() instanceof ColumnSegment)) continue;
            joinConditions.add((BinaryOperationExpression)each.getExpr());
        }
    }

    @Generated
    private ExpressionExtractUtils() {
    }
}

