/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.statistics.collector.tables;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereRowData;
import org.apache.shardingsphere.infra.metadata.statistics.ShardingSphereTableData;
import org.apache.shardingsphere.infra.metadata.statistics.collector.ShardingSphereStatisticsCollector;
import org.apache.shardingsphere.infra.metadata.statistics.collector.ShardingSphereTableDataCollectorUtils;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;

public final class PgClassTableCollector
implements ShardingSphereStatisticsCollector {
    private static final String PG_CLASS = "pg_class";
    private static final String COLUMN_NAMES = "relname, relnamespace, relkind, reloptions";
    private static final String SELECT_SQL = "SELECT relname, relnamespace, relkind, reloptions FROM pg_catalog.pg_class WHERE relkind IN ('r','v','m','S','L','f','e','o','') AND relname NOT LIKE 'matviewmap\\_%' AND relname NOT LIKE 'mlog\\_%' AND pg_catalog.pg_table_is_visible(oid);";

    @Override
    public Optional<ShardingSphereTableData> collect(String databaseName, ShardingSphereTable table, Map<String, ShardingSphereDatabase> shardingSphereDatabases) throws SQLException {
        Collection<ShardingSphereRowData> rows = ShardingSphereTableDataCollectorUtils.collectRowData(shardingSphereDatabases.get(databaseName), table, Arrays.stream(COLUMN_NAMES.split(",")).map(String::trim).collect(Collectors.toList()), SELECT_SQL);
        Collection<ShardingSphereRowData> rowData = this.decorateTableName(rows, table, shardingSphereDatabases.get(databaseName).getRuleMetaData().getRules());
        ShardingSphereTableData result = new ShardingSphereTableData(PG_CLASS);
        result.getRows().addAll(rowData);
        return Optional.of(result);
    }

    private Collection<ShardingSphereRowData> decorateTableName(Collection<ShardingSphereRowData> rows, ShardingSphereTable table, Collection<ShardingSphereRule> rules) {
        Collection dataNodeContainedRules = rules.stream().filter(DataNodeContainedRule.class::isInstance).map(DataNodeContainedRule.class::cast).collect(Collectors.toList());
        if (dataNodeContainedRules.isEmpty()) {
            return rows;
        }
        int tableNameIndex = table.getColumnNames().indexOf("relname");
        LinkedList<ShardingSphereRowData> result = new LinkedList<ShardingSphereRowData>();
        for (ShardingSphereRowData each : rows) {
            String tableName = (String)each.getRows().get(tableNameIndex);
            String logicTableName = this.decorateTableName(dataNodeContainedRules, tableName);
            ArrayList<Object> decoratedRow = new ArrayList<Object>(each.getRows());
            decoratedRow.set(tableNameIndex, logicTableName);
            result.add(new ShardingSphereRowData(decoratedRow));
        }
        return result;
    }

    private String decorateTableName(Collection<DataNodeContainedRule> dataNodeContainedRules, String actualTableName) {
        for (DataNodeContainedRule each : dataNodeContainedRules) {
            if (!each.findLogicTableByActualTable(actualTableName).isPresent()) continue;
            return each.findLogicTableByActualTable(actualTableName).get();
        }
        return actualTableName;
    }

    public String getType() {
        return PG_CLASS;
    }
}

