/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.metadata.database.resource;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.datasource.pool.CatalogSwitchableDataSource;
import org.apache.shardingsphere.infra.metadata.database.resource.node.StorageNode;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnitNodeMapper;

public final class StorageResource {
    private final Map<StorageNode, DataSource> dataSourceMap;
    private final Map<String, StorageUnitNodeMapper> storageUnitNodeMappers;
    private final Map<String, DataSource> wrappedDataSources;

    public StorageResource(Map<StorageNode, DataSource> dataSourceMap, Map<String, StorageUnitNodeMapper> storageUnitNodeMappers) {
        this.dataSourceMap = dataSourceMap;
        this.storageUnitNodeMappers = storageUnitNodeMappers;
        this.wrappedDataSources = this.createWrappedDataSources();
    }

    private Map<String, DataSource> createWrappedDataSources() {
        LinkedHashMap<String, DataSource> result = new LinkedHashMap<String, DataSource>(this.storageUnitNodeMappers.size(), 1.0f);
        for (Map.Entry<String, StorageUnitNodeMapper> entry : this.storageUnitNodeMappers.entrySet()) {
            DataSource dataSource = this.dataSourceMap.get(entry.getValue().getStorageNode());
            if (null == dataSource) continue;
            result.put(entry.getKey(), (DataSource)new CatalogSwitchableDataSource(dataSource, entry.getValue().getCatalog(), entry.getValue().getUrl()));
        }
        return result;
    }

    @Generated
    public Map<StorageNode, DataSource> getDataSourceMap() {
        return this.dataSourceMap;
    }

    @Generated
    public Map<String, StorageUnitNodeMapper> getStorageUnitNodeMappers() {
        return this.storageUnitNodeMappers;
    }

    @Generated
    public Map<String, DataSource> getWrappedDataSources() {
        return this.wrappedDataSources;
    }
}

