/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.datanode;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.datanode.DataNodeBuilder;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.identifier.type.DataNodeContainedRule;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPILoader;

public final class DataNodes {
    private final Collection<ShardingSphereRule> rules;
    private final Map<ShardingSphereRule, DataNodeBuilder> dataNodeBuilders;

    public DataNodes(Collection<ShardingSphereRule> rules) {
        this.rules = rules;
        this.dataNodeBuilders = OrderedSPILoader.getServices(DataNodeBuilder.class, rules);
    }

    public Collection<DataNode> getDataNodes(String tableName) {
        Optional<DataNodeContainedRule> dataNodeContainedRule = this.findDataNodeContainedRule(tableName);
        if (!dataNodeContainedRule.isPresent()) {
            return Collections.emptyList();
        }
        Collection<DataNode> result = new LinkedList<DataNode>(dataNodeContainedRule.get().getDataNodesByTableName(tableName));
        for (Map.Entry<ShardingSphereRule, DataNodeBuilder> entry : this.dataNodeBuilders.entrySet()) {
            result = entry.getValue().build(result, entry.getKey());
        }
        return result;
    }

    private Optional<DataNodeContainedRule> findDataNodeContainedRule(String tableName) {
        return this.rules.stream().filter(each -> this.isDataNodeContainedRuleContainsTable((ShardingSphereRule)each, tableName)).findFirst().map(DataNodeContainedRule.class::cast);
    }

    private boolean isDataNodeContainedRuleContainsTable(ShardingSphereRule each, String tableName) {
        return each instanceof DataNodeContainedRule && !((DataNodeContainedRule)each).getDataNodesByTableName(tableName).isEmpty();
    }

    @Generated
    public DataNodes(Collection<ShardingSphereRule> rules, Map<ShardingSphereRule, DataNodeBuilder> dataNodeBuilders) {
        this.rules = rules;
        this.dataNodeBuilders = dataNodeBuilders;
    }
}

