/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.config.database.impl;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.props.creator.DataSourcePoolPropertiesCreator;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.metadata.database.resource.StorageResource;
import org.apache.shardingsphere.infra.metadata.database.resource.StorageResourceUtils;

public final class DataSourceProvidedDatabaseConfiguration
implements DatabaseConfiguration {
    private final StorageResource storageResource;
    private final Collection<RuleConfiguration> ruleConfigurations;
    private final Map<String, DataSourcePoolProperties> dataSourcePoolPropertiesMap;

    public DataSourceProvidedDatabaseConfiguration(Map<String, DataSource> dataSources, Collection<RuleConfiguration> ruleConfigs) {
        this.ruleConfigurations = ruleConfigs;
        this.storageResource = new StorageResource(StorageResourceUtils.getStorageNodeDataSources(dataSources), StorageResourceUtils.getStorageUnitNodeMappers(dataSources));
        this.dataSourcePoolPropertiesMap = this.createDataSourcePoolPropertiesMap(dataSources);
    }

    private Map<String, DataSourcePoolProperties> createDataSourcePoolPropertiesMap(Map<String, DataSource> dataSources) {
        return dataSources.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DataSourcePoolPropertiesCreator.create((DataSource)((DataSource)entry.getValue())), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    @Override
    public Map<String, DataSource> getDataSources() {
        return this.storageResource.getWrappedDataSources();
    }

    @Generated
    public DataSourceProvidedDatabaseConfiguration(StorageResource storageResource, Collection<RuleConfiguration> ruleConfigurations, Map<String, DataSourcePoolProperties> dataSourcePoolPropertiesMap) {
        this.storageResource = storageResource;
        this.ruleConfigurations = ruleConfigurations;
        this.dataSourcePoolPropertiesMap = dataSourcePoolPropertiesMap;
    }

    @Override
    @Generated
    public StorageResource getStorageResource() {
        return this.storageResource;
    }

    @Override
    @Generated
    public Collection<RuleConfiguration> getRuleConfigurations() {
        return this.ruleConfigurations;
    }

    @Override
    @Generated
    public Map<String, DataSourcePoolProperties> getDataSourcePoolPropertiesMap() {
        return this.dataSourcePoolPropertiesMap;
    }
}

