/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.config.database.impl;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.config.DataSourceConfiguration;
import org.apache.shardingsphere.infra.datasource.pool.props.creator.DataSourcePoolPropertiesCreator;
import org.apache.shardingsphere.infra.datasource.pool.props.domain.DataSourcePoolProperties;
import org.apache.shardingsphere.infra.metadata.database.resource.StorageResource;
import org.apache.shardingsphere.infra.metadata.database.resource.StorageResourceCreator;

public final class DataSourceGeneratedDatabaseConfiguration
implements DatabaseConfiguration {
    private final StorageResource storageResource;
    private final Collection<RuleConfiguration> ruleConfigurations;
    private final Map<String, DataSourcePoolProperties> dataSourcePoolPropertiesMap;

    public DataSourceGeneratedDatabaseConfiguration(Map<String, DataSourceConfiguration> dataSourceConfigs, Collection<RuleConfiguration> ruleConfigs) {
        this.ruleConfigurations = ruleConfigs;
        this.dataSourcePoolPropertiesMap = dataSourceConfigs.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DataSourcePoolPropertiesCreator.create((DataSourceConfiguration)((DataSourceConfiguration)entry.getValue())), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
        this.storageResource = StorageResourceCreator.createStorageResource(this.dataSourcePoolPropertiesMap);
    }

    @Override
    public Map<String, DataSource> getDataSources() {
        return this.storageResource.getWrappedDataSources();
    }

    @Override
    @Generated
    public StorageResource getStorageResource() {
        return this.storageResource;
    }

    @Override
    @Generated
    public Collection<RuleConfiguration> getRuleConfigurations() {
        return this.ruleConfigurations;
    }

    @Override
    @Generated
    public Map<String, DataSourcePoolProperties> getDataSourcePoolPropertiesMap() {
        return this.dataSourcePoolPropertiesMap;
    }
}

