/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.autogen.version;

import java.util.Properties;

public final class ShardingSphereVersion {
    public static final String VERSION = "5.4.1";
    public static final boolean IS_SNAPSHOT;
    public static final String BUILD_BRANCH;
    public static final String BUILD_TIME;
    public static final String BUILD_GIT_COMMIT_ID;
    public static final String BUILD_GIT_COMMIT_ID_ABBREV;
    public static final String BUILD_GIT_COMMIT_MESSAGE_SHORT;
    public static final String BUILD_GIT_TAG;
    public static final boolean BUILD_GIT_DIRTY;

    private ShardingSphereVersion() {
    }

    public static void main(String[] args) {
        System.out.print(ShardingSphereVersion.getVerboseVersion());
    }

    private static String getVerboseVersion() {
        String result = "";
        result = result + String.format("ShardingSphere-%s%n", VERSION);
        if (IS_SNAPSHOT && !BUILD_GIT_COMMIT_ID.isEmpty()) {
            result = result + String.format("Commit ID: %s%s%n", BUILD_GIT_DIRTY ? "dirty-" : "", BUILD_GIT_COMMIT_ID);
            result = result + String.format("Commit Message: %s%n", BUILD_GIT_COMMIT_MESSAGE_SHORT);
            result = result + (BUILD_GIT_TAG.isEmpty() ? String.format("Branch: %s%n", BUILD_BRANCH) : String.format("Tag: %s%n", BUILD_GIT_TAG));
            result = result + String.format("Build time: %s%n", BUILD_TIME);
        }
        return result;
    }

    static {
        Properties info = new Properties();
        try {
            info.load(ShardingSphereVersion.class.getResourceAsStream("/current-git-commit.properties"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        IS_SNAPSHOT = VERSION.endsWith("SNAPSHOT");
        BUILD_BRANCH = info.getProperty("git.branch", "");
        BUILD_TIME = info.getProperty("git.build.time", "");
        BUILD_GIT_COMMIT_ID = info.getProperty("git.commit.id", "");
        BUILD_GIT_COMMIT_ID_ABBREV = info.getProperty("git.commit.id.abbrev", "");
        BUILD_GIT_COMMIT_MESSAGE_SHORT = info.getProperty("git.commit.message.short", "");
        BUILD_GIT_TAG = info.getProperty("git.tags", "");
        BUILD_GIT_DIRTY = Boolean.parseBoolean(info.getProperty("git.dirty"));
    }
}

