/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.datasource.config.impl;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.impl.StandardPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.spi.datasource.JdbcQueryPropertiesExtension;
import org.apache.shardingsphere.infra.database.core.connector.url.JdbcUrlAppender;
import org.apache.shardingsphere.infra.database.core.connector.url.StandardJdbcUrlParser;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeFactory;
import org.apache.shardingsphere.infra.util.yaml.YamlConfiguration;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRootConfiguration;
import org.apache.shardingsphere.infra.yaml.config.pojo.rule.YamlRuleConfiguration;

public final class ShardingSpherePipelineDataSourceConfiguration
implements PipelineDataSourceConfiguration {
    public static final String TYPE = "ShardingSphereJDBC";
    private final String parameter;
    private final YamlRootConfiguration rootConfig;
    private final DatabaseType databaseType;

    public ShardingSpherePipelineDataSourceConfiguration(String param) {
        this.rootConfig = (YamlRootConfiguration)YamlEngine.unmarshal((String)param, YamlRootConfiguration.class, (boolean)true);
        for (Map each : this.rootConfig.getDataSources().values()) {
            each.remove("dataSourceProperties");
        }
        this.parameter = YamlEngine.marshal((Object)this.rootConfig);
        Map props = (Map)this.rootConfig.getDataSources().values().iterator().next();
        this.databaseType = DatabaseTypeFactory.get((String)this.getJdbcUrl(props));
        this.appendJdbcQueryProperties(this.databaseType);
        this.adjustDataSourcePoolProperties(this.rootConfig.getDataSources());
    }

    public ShardingSpherePipelineDataSourceConfiguration(YamlRootConfiguration rootConfig) {
        this(YamlEngine.marshal((Object)ShardingSpherePipelineDataSourceConfiguration.getYamlParameterConfiguration(rootConfig)));
    }

    private static YamlParameterConfiguration getYamlParameterConfiguration(YamlRootConfiguration rootConfig) {
        YamlParameterConfiguration result = new YamlParameterConfiguration();
        result.setDatabaseName(rootConfig.getDatabaseName());
        result.setDataSources(rootConfig.getDataSources());
        result.setRules(rootConfig.getRules());
        return result;
    }

    private String getJdbcUrl(Map<String, Object> props) {
        Object result = props.getOrDefault("url", props.get("jdbcUrl"));
        Preconditions.checkNotNull((Object)result, (Object)"url or jdbcUrl is required.");
        return result.toString();
    }

    private void appendJdbcQueryProperties(DatabaseType databaseType) {
        Optional extension = DatabaseTypedSPILoader.findService(JdbcQueryPropertiesExtension.class, (DatabaseType)databaseType);
        if (!extension.isPresent()) {
            return;
        }
        StandardJdbcUrlParser standardJdbcUrlParser = new StandardJdbcUrlParser();
        this.rootConfig.getDataSources().forEach((key, value) -> {
            String jdbcUrlKey = value.containsKey("url") ? "url" : "jdbcUrl";
            String jdbcUrl = value.get(jdbcUrlKey).toString();
            Properties queryProps = standardJdbcUrlParser.parseQueryProperties(jdbcUrl.contains("?") ? jdbcUrl.substring(jdbcUrl.indexOf("?") + 1) : "");
            ((JdbcQueryPropertiesExtension)extension.get()).extendQueryProperties(queryProps);
            value.replace(jdbcUrlKey, new JdbcUrlAppender().appendQueryProperties(jdbcUrl, queryProps));
        });
    }

    private void adjustDataSourcePoolProperties(Map<String, Map<String, Object>> dataSources) {
        for (Map<String, Object> queryProps : dataSources.values()) {
            for (String each : Arrays.asList("minPoolSize", "minimumIdle")) {
                queryProps.put(each, "1");
            }
        }
    }

    @Override
    public Object getDataSourceConfiguration() {
        return this.rootConfig;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public StandardPipelineDataSourceConfiguration getActualDataSourceConfiguration(String actualDataSourceName) {
        Map yamlDataSourceConfig = (Map)this.rootConfig.getDataSources().get(actualDataSourceName);
        Preconditions.checkNotNull((Object)yamlDataSourceConfig, (String)"actualDataSourceName '{}' does not exist", (Object)actualDataSourceName);
        return new StandardPipelineDataSourceConfiguration(yamlDataSourceConfig);
    }

    @Override
    @Generated
    public String getParameter() {
        return this.parameter;
    }

    @Generated
    public YamlRootConfiguration getRootConfig() {
        return this.rootConfig;
    }

    @Override
    @Generated
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShardingSpherePipelineDataSourceConfiguration)) {
            return false;
        }
        ShardingSpherePipelineDataSourceConfiguration other = (ShardingSpherePipelineDataSourceConfiguration)o;
        String this$parameter = this.getParameter();
        String other$parameter = other.getParameter();
        return !(this$parameter == null ? other$parameter != null : !this$parameter.equals(other$parameter));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $parameter = this.getParameter();
        result = result * 59 + ($parameter == null ? 43 : $parameter.hashCode());
        return result;
    }

    private static class YamlParameterConfiguration
    implements YamlConfiguration {
        private String databaseName;
        private Map<String, Map<String, Object>> dataSources = new HashMap<String, Map<String, Object>>();
        private Collection<YamlRuleConfiguration> rules = new LinkedList<YamlRuleConfiguration>();

        private YamlParameterConfiguration() {
        }

        @Generated
        public String getDatabaseName() {
            return this.databaseName;
        }

        @Generated
        public Map<String, Map<String, Object>> getDataSources() {
            return this.dataSources;
        }

        @Generated
        public Collection<YamlRuleConfiguration> getRules() {
            return this.rules;
        }

        @Generated
        public void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Generated
        public void setDataSources(Map<String, Map<String, Object>> dataSources) {
            this.dataSources = dataSources;
        }

        @Generated
        public void setRules(Collection<YamlRuleConfiguration> rules) {
            this.rules = rules;
        }
    }
}

