/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.metadata.LogicTableName;

public final class TableNameSchemaNameMapping {
    private final Map<LogicTableName, String> mapping;

    public TableNameSchemaNameMapping(Map<String, String> tableSchemaMap) {
        this.mapping = null == tableSchemaMap ? Collections.emptyMap() : this.getLogicTableNameMap(tableSchemaMap);
    }

    private Map<LogicTableName, String> getLogicTableNameMap(Map<String, String> tableSchemaMap) {
        HashMap<LogicTableName, String> result = new HashMap<LogicTableName, String>(tableSchemaMap.size(), 1.0f);
        for (Map.Entry<String, String> entry : tableSchemaMap.entrySet()) {
            String tableName = entry.getKey();
            String schemaName = entry.getValue();
            if (null == schemaName) continue;
            result.put(new LogicTableName(tableName), schemaName);
        }
        return result;
    }

    public String getSchemaName(String logicTableName) {
        return this.mapping.get(new LogicTableName(logicTableName));
    }

    public String getSchemaName(LogicTableName logicTableName) {
        return this.mapping.get(logicTableName);
    }

    @Generated
    public String toString() {
        return "TableNameSchemaNameMapping(mapping=" + this.mapping + ")";
    }
}

