/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shale.test.mock;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletException;

public class MockServletContext
implements ServletContext {
    private List attributeListeners = new ArrayList();
    private Hashtable attributes = new Hashtable();
    private File documentRoot = null;
    private Hashtable mimeTypes = new Hashtable();
    private Hashtable parameters = new Hashtable();

    public void addAttributeListener(ServletContextAttributeListener listener) {
        this.attributeListeners.add(listener);
    }

    public void addInitParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public void addMimeType(String extension, String contentType) {
        this.mimeTypes.put(extension, contentType);
    }

    public void setDocumentRoot(File documentRoot) {
        this.documentRoot = documentRoot;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return this.attributes.keys();
    }

    public ServletContext getContext(String uripath) {
        throw new UnsupportedOperationException();
    }

    public String getContextPath() {
        throw new UnsupportedOperationException();
    }

    public String getInitParameter(String name) {
        return (String)this.parameters.get(name);
    }

    public Enumeration getInitParameterNames() {
        return this.parameters.keys();
    }

    public int getMajorVersion() {
        return 2;
    }

    public String getMimeType(String path) {
        int period = path.lastIndexOf(46);
        if (period < 0) {
            return null;
        }
        String extension = path.substring(period + 1);
        return (String)this.mimeTypes.get(extension);
    }

    public int getMinorVersion() {
        return 4;
    }

    public RequestDispatcher getNamedDispatcher(String name) {
        throw new UnsupportedOperationException();
    }

    public String getRealPath(String path) {
        if (this.documentRoot != null) {
            if (!path.startsWith("/")) {
                throw new IllegalArgumentException("The specified path ('" + path + "') does not start with a '/' character");
            }
            File resolved = new File(this.documentRoot, path.substring(1));
            try {
                return resolved.getCanonicalPath();
            }
            catch (IOException e) {
                return resolved.getAbsolutePath();
            }
        }
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new UnsupportedOperationException();
    }

    public URL getResource(String path) throws MalformedURLException {
        if (this.documentRoot != null) {
            if (!path.startsWith("/")) {
                throw new MalformedURLException("The specified path ('" + path + "') does not start with a '/' character");
            }
            File resolved = new File(this.documentRoot, path.substring(1));
            if (resolved.exists()) {
                return resolved.toURL();
            }
            return null;
        }
        return null;
    }

    public InputStream getResourceAsStream(String path) {
        try {
            URL url = this.getResource(path);
            if (url != null) {
                return url.openStream();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Set getResourcePaths(String path) {
        if (this.documentRoot == null) {
            return null;
        }
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The specified path ('" + path + "') does not start with a '/' character");
        }
        File node = new File(this.documentRoot, path.substring(1));
        if (!node.exists()) {
            return null;
        }
        if (!node.isDirectory()) {
            return null;
        }
        HashSet<String> set = new HashSet<String>();
        String[] files = node.list();
        if (files == null) {
            return null;
        }
        for (int i = 0; i < files.length; ++i) {
            String subfile = path + files[i];
            File subnode = new File(node, files[i]);
            if (subnode.isDirectory()) {
                subfile = subfile + "/";
            }
            set.add(subfile);
        }
        return set;
    }

    public Servlet getServlet(String name) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public String getServletContextName() {
        return "MockServletContext";
    }

    public String getServerInfo() {
        return "MockServletContext";
    }

    public Enumeration getServlets() {
        throw new UnsupportedOperationException();
    }

    public Enumeration getServletNames() {
        throw new UnsupportedOperationException();
    }

    public void log(String message) {
        System.out.println(message);
    }

    public void log(Exception exception, String message) {
        System.out.println(message);
        exception.printStackTrace();
    }

    public void log(String message, Throwable exception) {
        System.out.println(message);
        exception.printStackTrace();
    }

    public void removeAttribute(String name) {
        if (this.attributes.containsKey(name)) {
            Object value = this.attributes.remove(name);
            this.fireAttributeRemoved(name, value);
        }
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("Attribute name cannot be null");
        }
        if (value == null) {
            this.removeAttribute(name);
            return;
        }
        if (this.attributes.containsKey(name)) {
            Object oldValue = this.attributes.get(name);
            this.attributes.put(name, value);
            this.fireAttributeReplaced(name, oldValue);
        } else {
            this.attributes.put(name, value);
            this.fireAttributeAdded(name, value);
        }
    }

    private void fireAttributeAdded(String key, Object value) {
        if (this.attributeListeners.size() < 1) {
            return;
        }
        ServletContextAttributeEvent event = new ServletContextAttributeEvent((ServletContext)this, key, value);
        Iterator listeners = this.attributeListeners.iterator();
        while (listeners.hasNext()) {
            ServletContextAttributeListener listener = (ServletContextAttributeListener)listeners.next();
            listener.attributeAdded(event);
        }
    }

    private void fireAttributeRemoved(String key, Object value) {
        if (this.attributeListeners.size() < 1) {
            return;
        }
        ServletContextAttributeEvent event = new ServletContextAttributeEvent((ServletContext)this, key, value);
        Iterator listeners = this.attributeListeners.iterator();
        while (listeners.hasNext()) {
            ServletContextAttributeListener listener = (ServletContextAttributeListener)listeners.next();
            listener.attributeRemoved(event);
        }
    }

    private void fireAttributeReplaced(String key, Object value) {
        if (this.attributeListeners.size() < 1) {
            return;
        }
        ServletContextAttributeEvent event = new ServletContextAttributeEvent((ServletContext)this, key, value);
        Iterator listeners = this.attributeListeners.iterator();
        while (listeners.hasNext()) {
            ServletContextAttributeListener listener = (ServletContextAttributeListener)listeners.next();
            listener.attributeReplaced(event);
        }
    }
}

