/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.ws.spi;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.geronimo.osgi.locator.ProviderLocator;
import org.apache.servicemix.specs.locator.OsgiLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FactoryFinder {
    private static final boolean debug = false;

    FactoryFinder() {
    }

    private static void debugPrintln(String msg) {
    }

    private static ClassLoader findClassLoader() throws ConfigurationError {
        ClassLoader cl = (ClassLoader)FactoryFinder.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Method m = null;
                try {
                    m = Thread.class.getMethod("getContextClassLoader", null);
                }
                catch (NoSuchMethodException e) {
                    FactoryFinder.debugPrintln("assuming JDK 1.1");
                    return FactoryFinder.class.getClassLoader();
                }
                try {
                    return (ClassLoader)m.invoke((Object)Thread.currentThread(), (Object[])null);
                }
                catch (IllegalAccessException e) {
                    throw new ConfigurationError("Unexpected IllegalAccessException", e);
                }
                catch (InvocationTargetException e) {
                    throw new ConfigurationError("Unexpected InvocationTargetException", e);
                }
            }
        });
        return cl;
    }

    private static Object newInstance(String className, ClassLoader classLoader) throws ConfigurationError {
        final ClassLoader iClassLoader = classLoader;
        final String iClassName = className;
        Object obj = FactoryFinder.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return ProviderLocator.loadClass(iClassName, FactoryFinder.class, iClassLoader).newInstance();
                }
                catch (ClassNotFoundException x) {
                    throw new ConfigurationError("Provider " + iClassName + " not found", x);
                }
                catch (Exception x) {
                    throw new ConfigurationError("Provider " + iClassName + " could not be instantiated: " + x, x);
                }
            }
        });
        return obj;
    }

    static Object find(String factoryId, String fallbackClassName) throws ConfigurationError {
        final String iFactoryId = factoryId;
        final String iFallbackClassName = fallbackClassName;
        Object obj = FactoryFinder.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                FactoryFinder.debugPrintln("debug is on");
                ClassLoader classLoader = FactoryFinder.findClassLoader();
                try {
                    Class<?> factoryClass = null;
                    factoryClass = FactoryFinder.class.getClassLoader() != null ? FactoryFinder.class.getClassLoader().loadClass(iFactoryId) : Class.forName(iFactoryId);
                    Class<?> spiClass = OsgiLocator.locate(factoryClass, iFactoryId);
                    if (spiClass != null) {
                        return spiClass.newInstance();
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
                try {
                    Object service = ProviderLocator.getService(iFactoryId, FactoryFinder.class, classLoader);
                    if (service != null) {
                        return service;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    String factoryClassName = ProviderLocator.lookupByJREPropertyFile("lib" + File.separator + "jaxrpc.properties", iFactoryId);
                    if (factoryClassName != null) {
                        FactoryFinder.debugPrintln("found java.home property " + factoryClassName);
                        return FactoryFinder.newInstance(factoryClassName, classLoader);
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    String systemProp = System.getProperty(iFactoryId);
                    if (systemProp != null) {
                        FactoryFinder.debugPrintln("found system property " + systemProp);
                        return FactoryFinder.newInstance(systemProp, classLoader);
                    }
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (iFallbackClassName == null) {
                    throw new ConfigurationError("Provider for " + iFactoryId + " cannot be found", null);
                }
                FactoryFinder.debugPrintln("loaded from fallback value: " + iFallbackClassName);
                return FactoryFinder.newInstance(iFallbackClassName, classLoader);
            }
        });
        return obj;
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return action.run();
        }
        return AccessController.doPrivileged(action);
    }

    static class ConfigurationError
    extends Error {
        private Exception exception;

        ConfigurationError(String msg, Exception x) {
            super(msg);
            this.exception = x;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

