/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.utils;

import com.hazelcast.cluster.Address;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import org.apache.seatunnel.engine.server.resourcemanager.resource.SlotAssignedProfile;
import org.apache.seatunnel.engine.server.resourcemanager.resource.SystemLoadInfo;
import org.apache.seatunnel.engine.server.resourcemanager.worker.WorkerProfile;
import org.apache.seatunnel.shade.com.google.common.collect.EvictingQueue;

public class SystemLoadCalculate {
    private static final int MAX_TIME_WINDOW = 5;
    private static final double[] TIME_WEIGHT_RATIOS = new double[]{4.0, 2.0, 2.0, 1.0, 1.0};
    private static final double CPU_WEIGHT = 0.5;
    private static final double MEMORY_WEIGHT = 0.5;
    final double RESOURCE_AVAILABILITY_WEIGHT = 0.7;
    final double SLOT_WEIGHT = 0.3;
    private final LinkedList<UtilizationData> utilizationHistory = new LinkedList();

    public void addUtilizationData(double cpuUtilization, double memoryUtilization) {
        if (cpuUtilization < 0.0 || cpuUtilization > 1.0 || memoryUtilization < 0.0 || memoryUtilization > 1.0) {
            throw new IllegalArgumentException("Utilization values must be between 0 and 1");
        }
        if (this.utilizationHistory.size() >= 5) {
            this.utilizationHistory.removeLast();
        }
        this.utilizationHistory.addFirst(new UtilizationData(cpuUtilization, memoryUtilization));
    }

    private double[] generateTimeWeights() {
        int i;
        int size = this.utilizationHistory.size();
        if (size == 0) {
            return new double[0];
        }
        int weightCount = Math.min(size, TIME_WEIGHT_RATIOS.length);
        double[] weights = new double[size];
        double totalWeight = 0.0;
        for (i = 0; i < size; ++i) {
            weights[i] = i < weightCount ? TIME_WEIGHT_RATIOS[i] : TIME_WEIGHT_RATIOS[weightCount - 1];
            totalWeight += weights[i];
        }
        i = 0;
        while (i < size) {
            int n = i++;
            weights[n] = weights[n] / totalWeight;
        }
        return weights;
    }

    public double calculateSchedulingPriority() {
        if (this.utilizationHistory.isEmpty()) {
            return 1.0;
        }
        double[] timeWeights = this.generateTimeWeights();
        double prioritySum = 0.0;
        int index = 0;
        for (UtilizationData data : this.utilizationHistory) {
            double resourceAvailability = this.calculateResourceAvailability(data);
            prioritySum += resourceAvailability * timeWeights[index++];
        }
        return prioritySum;
    }

    public double calculate(EvictingQueue<SystemLoadInfo> systemLoads, WorkerProfile workerProfile, Map<Address, SlotAssignedProfile> workerAssignedSlots) {
        if (Objects.isNull(systemLoads) || systemLoads.isEmpty()) {
            return 0.0;
        }
        systemLoads.forEach(v -> {
            Double cpuPercentage = v.getCpuPercentage();
            Double memPercentage = v.getMemPercentage();
            this.addUtilizationData(cpuPercentage, memPercentage);
        });
        double comprehensiveResourceAvailability = this.calculateSchedulingPriority();
        double resourceAvailabilityStep4 = this.calculateComprehensiveResourceAvailability(comprehensiveResourceAvailability, workerProfile, workerAssignedSlots);
        double slotWeight = this.balanceFactor(workerProfile, workerAssignedSlots);
        return this.calculateResourceAvailability(resourceAvailabilityStep4, slotWeight);
    }

    public double calculateResourceAvailability(double resourceAvailabilityStep4, double slotWeight) {
        return 0.7 * resourceAvailabilityStep4 + 0.3 * slotWeight;
    }

    private double calculateResourceAvailability(UtilizationData data) {
        double cpuAvailability = 1.0 - data.cpuUtilization;
        double memoryAvailability = 1.0 - data.memoryUtilization;
        return (cpuAvailability * 0.5 + memoryAvailability * 0.5) / 1.0;
    }

    public double calculateComprehensiveResourceAvailability(double comprehensiveResourceAvailability, WorkerProfile workerProfile, Map<Address, SlotAssignedProfile> workerAssignedSlots) {
        SlotAssignedProfile slotAssignedProfile;
        int assignedSlotsNum = workerProfile.getAssignedSlots().length;
        double singleSlotUseResource = 0.1;
        if (workerAssignedSlots.get(workerProfile.getAddress()) == null) {
            if (assignedSlotsNum != 0) {
                singleSlotUseResource = (double)Math.round((1.0 - comprehensiveResourceAvailability) / (double)assignedSlotsNum * 100.0) / 100.0;
            }
            slotAssignedProfile = workerAssignedSlots.getOrDefault(workerProfile.getAddress(), new SlotAssignedProfile(singleSlotUseResource, 0, assignedSlotsNum));
        } else {
            slotAssignedProfile = workerAssignedSlots.get(workerProfile.getAddress());
            singleSlotUseResource = slotAssignedProfile.getSingleSlotUseResource();
        }
        Integer assignedTimesForTask = slotAssignedProfile.getCurrentTaskAssignedSlotsNum();
        return comprehensiveResourceAvailability -= (double)assignedTimesForTask.intValue() * singleSlotUseResource;
    }

    public double balanceFactor(WorkerProfile workerProfile, Map<Address, SlotAssignedProfile> workerAssignedSlots) {
        SlotAssignedProfile slotAssignedProfile = workerAssignedSlots.get(workerProfile.getAddress());
        if (slotAssignedProfile != null) {
            return this.balanceFactor(workerProfile, slotAssignedProfile.getCurrentTaskAssignedSlotsNum() + slotAssignedProfile.getAssignedSlotsNum());
        }
        return this.balanceFactor(workerProfile, workerProfile.getAssignedSlots().length);
    }

    public double balanceFactor(WorkerProfile workerProfile, Integer assignedSlots) {
        return 1.0 - (double)assignedSlots.intValue() / (double)(workerProfile.getAssignedSlots().length + workerProfile.getUnassignedSlots().length);
    }

    private static class UtilizationData {
        private final double cpuUtilization;
        private final double memoryUtilization;

        public UtilizationData(double cpuUtilization, double memoryUtilization) {
            this.cpuUtilization = cpuUtilization;
            this.memoryUtilization = memoryUtilization;
        }
    }
}

