/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.telemetry.metrics;

import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.jmx.ManagementService;
import com.hazelcast.logging.ILogger;
import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.apache.seatunnel.engine.server.CoordinatorService;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.shade.com.google.common.collect.Lists;

public abstract class AbstractCollector
extends Collector {
    protected static String CLUSTER = "cluster";
    protected static String ADDRESS = "address";
    protected Node node;

    public AbstractCollector(Node node) {
        this.node = node;
    }

    protected Node getNode() {
        return this.node;
    }

    protected ILogger getLogger(Class clazz) {
        return this.getNode().getLogger(clazz);
    }

    protected boolean isMaster() {
        return this.getNode().isMaster();
    }

    protected MemberImpl getLocalMember() {
        return this.getNode().nodeEngine.getLocalMember();
    }

    protected SeaTunnelServer getServer() {
        return (SeaTunnelServer)this.getNode().getNodeEngine().getService("st:impl:seaTunnelServer");
    }

    protected CoordinatorService getCoordinatorService() {
        return this.getServer().getCoordinatorService();
    }

    protected ManagementService getManagementService() {
        return this.getNode().hazelcastInstance.getManagementService();
    }

    protected ClusterService getClusterService() {
        return this.getNode().getClusterService();
    }

    protected String localAddress() {
        return this.getLocalMember().getInetAddress().getHostAddress() + ":" + this.getLocalMember().getPort();
    }

    protected String masterAddress() throws UnknownHostException {
        return this.getClusterService().getMasterAddress().getInetAddress().getHostAddress() + ":" + this.getClusterService().getMasterAddress().getPort();
    }

    protected String getClusterName() {
        return this.getNode().getConfig().getClusterName();
    }

    protected List<String> labelValues(String ... values) {
        ArrayList<String> labelValues = new ArrayList<String>();
        labelValues.add(this.getClusterName());
        if (values != null) {
            labelValues.addAll(Lists.newArrayList((Object[])values));
        }
        return labelValues;
    }

    protected List<String> clusterLabelNames(String ... labels) {
        ArrayList<String> labelNames = new ArrayList<String>();
        labelNames.add(CLUSTER);
        if (labels != null) {
            labelNames.addAll(Lists.newArrayList((Object[])labels));
        }
        return labelNames;
    }

    protected void longMetric(GaugeMetricFamily metricFamily, long count, List<String> labelValues) {
        metricFamily.addMetric(labelValues, (double)count);
    }

    protected void intMetric(GaugeMetricFamily metricFamily, int count, List<String> labelValues) {
        metricFamily.addMetric(labelValues, (double)count);
    }
}

