/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.operation.source;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.TaskExecutionService;
import org.apache.seatunnel.engine.server.exception.TaskGroupContextNotFoundException;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.serializable.TaskDataSerializerHook;
import org.apache.seatunnel.engine.server.task.SourceSplitEnumeratorTask;
import org.apache.seatunnel.engine.server.task.operation.TaskOperation;

public class RestoredSplitOperation
extends TaskOperation {
    private List<byte[]> splits;
    private Integer subtaskIndex;

    public RestoredSplitOperation() {
    }

    public RestoredSplitOperation(TaskLocation enumeratorLocation, List<byte[]> splits, int subtaskIndex) {
        super(enumeratorLocation);
        this.splits = splits;
        this.subtaskIndex = subtaskIndex;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.splits.size());
        for (byte[] split : this.splits) {
            out.writeByteArray(split);
        }
        out.writeInt(this.subtaskIndex.intValue());
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int splitCount = in.readInt();
        this.splits = new ArrayList<byte[]>(splitCount);
        for (int i = 0; i < splitCount; ++i) {
            this.splits.add(in.readByteArray());
        }
        this.subtaskIndex = in.readInt();
    }

    public int getFactoryId() {
        return TaskDataSerializerHook.FACTORY_ID;
    }

    public int getClassId() {
        return 14;
    }

    @Override
    public void runInternal() throws Exception {
        SeaTunnelServer server = (SeaTunnelServer)this.getService();
        TaskExecutionService taskExecutionService = server.getTaskExecutionService();
        RetryUtils.retryWithException(() -> {
            SourceSplitEnumeratorTask task = (SourceSplitEnumeratorTask)taskExecutionService.getTask(this.taskLocation);
            ClassLoader taskClassLoader = taskExecutionService.getExecutionContext(this.taskLocation.getTaskGroupLocation()).getClassLoader(task.getTaskID());
            ClassLoader mainClassLoader = Thread.currentThread().getContextClassLoader();
            ArrayList<Object> deserializeSplits = new ArrayList<Object>();
            try {
                Thread.currentThread().setContextClassLoader(taskClassLoader);
                for (byte[] split : this.splits) {
                    deserializeSplits.add(task.getSplitSerializer().deserialize(split));
                }
                task.addSplitsBack(deserializeSplits, this.subtaskIndex);
            }
            finally {
                Thread.currentThread().setContextClassLoader(mainClassLoader);
            }
            return null;
        }, (RetryUtils.RetryMaterial)new RetryUtils.RetryMaterial(30, true, exception -> exception instanceof TaskGroupContextNotFoundException && !server.taskIsEnded(this.taskLocation.getTaskGroupLocation()), 2000L));
    }
}

