/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.operation.checkpoint;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.checkpoint.operation.CheckpointErrorReportOperation;
import org.apache.seatunnel.engine.server.exception.TaskGroupContextNotFoundException;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.serializable.TaskDataSerializerHook;
import org.apache.seatunnel.engine.server.task.operation.TaskOperation;
import org.apache.seatunnel.engine.server.task.record.Barrier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BarrierFlowOperation
extends TaskOperation {
    private static final Logger log = LoggerFactory.getLogger(BarrierFlowOperation.class);
    protected Barrier barrier;

    public BarrierFlowOperation(Barrier barrier, TaskLocation taskLocation) {
        super(taskLocation);
        this.barrier = barrier;
    }

    public int getFactoryId() {
        return TaskDataSerializerHook.FACTORY_ID;
    }

    public int getClassId() {
        return 16;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject((Object)this.barrier);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.barrier = (Barrier)in.readObject();
    }

    @Override
    public void runInternal() throws Exception {
        SeaTunnelServer server = (SeaTunnelServer)this.getService();
        RetryUtils.retryWithException(() -> {
            Object task = server.getTaskExecutionService().getExecutionContext(this.taskLocation.getTaskGroupLocation()).getTaskGroup().getTask(this.taskLocation.getTaskID());
            task.getExecutionContext().getTaskExecutionService().asyncExecuteFunction(this.taskLocation.getTaskGroupLocation(), () -> {
                try {
                    log.debug("CheckpointBarrierTriggerOperation [{}]", (Object)this.taskLocation);
                    task.triggerBarrier(this.barrier);
                }
                catch (Exception e) {
                    task.getExecutionContext().sendToMaster(new CheckpointErrorReportOperation(this.taskLocation, e));
                }
            });
            return null;
        }, (RetryUtils.RetryMaterial)new RetryUtils.RetryMaterial(30, true, exception -> exception instanceof TaskGroupContextNotFoundException && !server.taskIsEnded(this.taskLocation.getTaskGroupLocation()), 2000L));
    }

    public BarrierFlowOperation() {
    }
}

