/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.operation;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.metrics.SeaTunnelMetricsContext;
import org.apache.seatunnel.engine.server.serializable.TaskDataSerializerHook;
import org.apache.seatunnel.engine.server.task.operation.TracingOperation;

public class ReportMetricsOperation
extends TracingOperation
implements IdentifiedDataSerializable {
    private Map<TaskLocation, SeaTunnelMetricsContext> localMap;

    public ReportMetricsOperation() {
    }

    public ReportMetricsOperation(Map<TaskLocation, SeaTunnelMetricsContext> localMap) {
        this.localMap = localMap;
    }

    @Override
    public void runInternal() throws Exception {
        SeaTunnelServer seaTunnelServer = (SeaTunnelServer)this.getService();
        if (this.localMap != null) {
            seaTunnelServer.updateMetrics(this.localMap);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.localMap == null ? 0 : this.localMap.size());
        if (this.localMap != null) {
            for (Map.Entry<TaskLocation, SeaTunnelMetricsContext> e : this.localMap.entrySet()) {
                out.writeObject((Object)e.getKey());
                out.writeObject((Object)e.getValue());
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        this.localMap = new HashMap<TaskLocation, SeaTunnelMetricsContext>(size);
        for (int i = 0; i < size; ++i) {
            TaskLocation key = (TaskLocation)in.readObject();
            SeaTunnelMetricsContext value = (SeaTunnelMetricsContext)((Object)in.readObject());
            this.localMap.put(key, value);
        }
    }

    public int getFactoryId() {
        return TaskDataSerializerHook.FACTORY_ID;
    }

    public int getClassId() {
        return 28;
    }
}

